/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.net.Address;
import io.scalecube.reactor.RetryNonSerializedEmitFailureHandler;
import io.scalecube.services.Injector;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceInfo;
import io.scalecube.services.ServiceProvider;
import io.scalecube.services.ServiceScanner;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.PrincipalMapper;
import io.scalecube.services.discovery.api.ServiceDiscovery;
import io.scalecube.services.discovery.api.ServiceDiscoveryContext;
import io.scalecube.services.discovery.api.ServiceDiscoveryEvent;
import io.scalecube.services.discovery.api.ServiceDiscoveryFactory;
import io.scalecube.services.discovery.api.ServiceDiscoveryOptions;
import io.scalecube.services.exceptions.DefaultErrorMapper;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.gateway.Gateway;
import io.scalecube.services.gateway.GatewayOptions;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodInvoker;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.methods.ServiceMethodRegistryImpl;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.routing.RoundRobinServiceRouter;
import io.scalecube.services.routing.Routers;
import io.scalecube.services.transport.api.ClientTransport;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.ServerTransport;
import io.scalecube.services.transport.api.ServiceMessageDataDecoder;
import io.scalecube.services.transport.api.ServiceTransport;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class Microservices {
    public static final Logger LOGGER = LoggerFactory.getLogger(Microservices.class);
    private final String id = UUID.randomUUID().toString();
    private final Map<String, String> tags;
    private final List<ServiceProvider> serviceProviders;
    private final ServiceRegistry serviceRegistry;
    private final ServiceMethodRegistry methodRegistry;
    private final Authenticator<Object> defaultAuthenticator;
    private final ServiceTransportBootstrap transportBootstrap;
    private final GatewayBootstrap gatewayBootstrap;
    private final CompositeServiceDiscovery compositeDiscovery;
    private final ServiceProviderErrorMapper defaultErrorMapper;
    private final ServiceMessageDataDecoder defaultDataDecoder;
    private final String defaultContentType;
    private final PrincipalMapper<Object, Object> defaultPrincipalMapper;
    private final Sinks.One<Void> shutdown = Sinks.one();
    private final Sinks.One<Void> onShutdown = Sinks.one();
    private ServiceEndpoint serviceEndpoint;
    private final String externalHost;
    private final Integer externalPort;

    private Microservices(Builder builder) {
        this.tags = Collections.unmodifiableMap(new HashMap(builder.tags));
        this.serviceProviders = new ArrayList<ServiceProvider>(builder.serviceProviders);
        this.serviceRegistry = builder.serviceRegistry;
        this.methodRegistry = builder.methodRegistry;
        this.defaultAuthenticator = builder.defaultAuthenticator;
        this.gatewayBootstrap = builder.gatewayBootstrap;
        this.compositeDiscovery = builder.compositeDiscovery;
        this.transportBootstrap = builder.transportBootstrap;
        this.defaultErrorMapper = builder.defaultErrorMapper;
        this.defaultDataDecoder = builder.defaultDataDecoder;
        this.defaultContentType = builder.defaultContentType;
        this.defaultPrincipalMapper = builder.defaultPrincipalMapper;
        this.externalHost = builder.externalHost;
        this.externalPort = builder.externalPort;
        this.shutdown.asMono().then(this.doShutdown()).doFinally(s -> this.onShutdown.emitEmpty((Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED)).subscribe(null, ex -> LOGGER.warn("[{}][doShutdown] Exception occurred: {}", (Object)this.id, (Object)ex.toString()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String id() {
        return this.id;
    }

    public String toString() {
        return "Microservices@" + this.id;
    }

    private Mono<Microservices> start() {
        LOGGER.info("[{}][start] Starting", (Object)this.id);
        Scheduler scheduler = Schedulers.newSingle((String)this.toString(), (boolean)true);
        return this.transportBootstrap.start(this).publishOn(scheduler).flatMap(transportBootstrap -> {
            ServiceCall call = this.call();
            Address serviceAddress = ((ServiceTransportBootstrap)transportBootstrap).transportAddress;
            ServiceEndpoint.Builder serviceEndpointBuilder = ServiceEndpoint.builder().id(this.id).address(serviceAddress).contentTypes(DataCodec.getAllContentTypes()).tags(this.tags);
            List serviceInstances = this.serviceProviders.stream().flatMap(serviceProvider -> serviceProvider.provide(call).stream()).peek(this::registerInMethodRegistry).peek(serviceInfo -> serviceEndpointBuilder.appendServiceRegistrations((Collection)ServiceScanner.scanServiceInfo((ServiceInfo)serviceInfo))).map(ServiceInfo::serviceInstance).collect(Collectors.toList());
            if (transportBootstrap == ServiceTransportBootstrap.NULL_INSTANCE && !serviceInstances.isEmpty()) {
                LOGGER.warn("[{}] ServiceTransport is not set", (Object)this.id());
            }
            this.serviceEndpoint = this.newServiceEndpoint(serviceEndpointBuilder.build());
            return this.createDiscovery(this, new ServiceDiscoveryOptions().serviceEndpoint(this.serviceEndpoint)).publishOn(scheduler).then(this.startGateway(new GatewayOptions().call(call))).publishOn(scheduler).then(Mono.fromCallable(() -> Injector.inject(this, serviceInstances))).then(Mono.fromCallable(() -> JmxMonitorMBean.start(this))).then(this.compositeDiscovery.startListen()).publishOn(scheduler).thenReturn((Object)this);
        }).onErrorResume(ex -> Mono.defer(this::shutdown).then(Mono.error((Throwable)ex)).cast(Microservices.class)).doOnSuccess(m -> LOGGER.info("[{}][start] Started", (Object)this.id)).doOnTerminate(() -> ((Scheduler)scheduler).dispose());
    }

    private ServiceEndpoint newServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        ServiceEndpoint.Builder builder = ServiceEndpoint.from((ServiceEndpoint)serviceEndpoint);
        int port = Optional.ofNullable(this.externalPort).orElse(serviceEndpoint.address().port());
        Address newAddress = Optional.ofNullable(this.externalHost).map(host -> Address.create((String)host, (int)port)).orElseGet(() -> Address.create((String)serviceEndpoint.address().host(), (int)port));
        return builder.address(newAddress).build();
    }

    private Mono<GatewayBootstrap> startGateway(GatewayOptions options) {
        return this.gatewayBootstrap.start(this, options);
    }

    private Mono<ServiceDiscovery> createDiscovery(Microservices microservices, ServiceDiscoveryOptions options) {
        return this.compositeDiscovery.createInstance(microservices, options);
    }

    private void registerInMethodRegistry(ServiceInfo serviceInfo) {
        this.methodRegistry.registerService(ServiceInfo.from((ServiceInfo)serviceInfo).errorMapperIfAbsent(this.defaultErrorMapper).dataDecoderIfAbsent(this.defaultDataDecoder).authenticatorIfAbsent(this.defaultAuthenticator).principalMapperIfAbsent(this.defaultPrincipalMapper).build());
    }

    public Address serviceAddress() {
        return this.transportBootstrap.transportAddress;
    }

    public ServiceCall call() {
        return new ServiceCall().transport(this.transportBootstrap.clientTransport).serviceRegistry(this.serviceRegistry).methodRegistry(this.methodRegistry).contentType(this.defaultContentType).errorMapper((ServiceClientErrorMapper)DefaultErrorMapper.INSTANCE).router(Routers.getRouter(RoundRobinServiceRouter.class));
    }

    public List<Gateway> gateways() {
        return this.gatewayBootstrap.gateways();
    }

    public Gateway gateway(String id) {
        return this.gatewayBootstrap.gateway(id);
    }

    public ServiceEndpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public List<ServiceEndpoint> serviceEndpoints() {
        return this.serviceRegistry.listServiceEndpoints();
    }

    public ServiceDiscoveryContext discovery() {
        return this.discovery("default");
    }

    public ServiceDiscoveryContext discovery(String id) {
        return (ServiceDiscoveryContext)Optional.ofNullable(this.compositeDiscovery.discoveryContexts.get(id)).orElseThrow(() -> new NoSuchElementException("[discovery] id: " + id));
    }

    public Flux<ServiceDiscoveryEvent> listenDiscovery() {
        return this.compositeDiscovery.listen();
    }

    public Mono<Void> shutdown() {
        return Mono.defer(() -> {
            this.shutdown.emitEmpty((Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED);
            return this.onShutdown.asMono();
        });
    }

    public Mono<Void> onShutdown() {
        return this.onShutdown.asMono();
    }

    private Mono<Void> doShutdown() {
        return Mono.defer(() -> {
            LOGGER.info("[{}][doShutdown] Shutting down", (Object)this.id);
            return Mono.whenDelayError((Publisher[])new Publisher[]{this.processBeforeDestroy(), this.compositeDiscovery.shutdown(), this.gatewayBootstrap.shutdown(), this.transportBootstrap.shutdown()}).doOnSuccess(s -> LOGGER.info("[{}][doShutdown] Shutdown", (Object)this.id));
        });
    }

    private Mono<Void> processBeforeDestroy() {
        return Mono.whenDelayError((Iterable)this.methodRegistry.listServices().stream().map(ServiceInfo::serviceInstance).map(s -> Mono.fromRunnable(() -> Injector.processBeforeDestroy(this, s))).collect(Collectors.toList()));
    }

    private static class JmxMonitorMBean
    implements MonitorMBean {
        private static final String OBJECT_NAME_FORMAT = "io.scalecube.services:name=%s@%s";
        private final Microservices microservices;

        private static JmxMonitorMBean start(Microservices instance) throws Exception {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            JmxMonitorMBean jmxMBean = new JmxMonitorMBean(instance);
            ObjectName objectName = new ObjectName(String.format(OBJECT_NAME_FORMAT, instance.id(), System.nanoTime()));
            StandardMBean standardMBean = new StandardMBean(jmxMBean, MonitorMBean.class);
            mbeanServer.registerMBean(standardMBean, objectName);
            return jmxMBean;
        }

        private JmxMonitorMBean(Microservices microservices) {
            this.microservices = microservices;
        }

        @Override
        public String getServiceEndpoint() {
            return String.valueOf(this.microservices.serviceEndpoint);
        }

        @Override
        public String getAllServiceEndpoints() {
            return this.microservices.serviceRegistry.listServiceEndpoints().stream().map(ServiceEndpoint::toString).collect(Collectors.joining(",", "[", "]"));
        }

        @Override
        public String getServiceMethodInvokers() {
            return this.microservices.methodRegistry.listInvokers().stream().map(JmxMonitorMBean::asString).collect(Collectors.joining(",", "[", "]"));
        }

        @Override
        public String getServiceInfos() {
            return this.microservices.methodRegistry.listServices().stream().map(JmxMonitorMBean::asString).collect(Collectors.joining(",", "[", "]"));
        }

        private static String asString(ServiceMethodInvoker invoker) {
            return new StringJoiner(", ", ServiceMethodInvoker.class.getSimpleName() + "[", "]").add("methodInfo=" + JmxMonitorMBean.asString(invoker.methodInfo())).add("serviceMethod=" + invoker.service().getClass().getCanonicalName() + "." + invoker.methodInfo().methodName() + "(" + invoker.methodInfo().parameterCount() + ")").toString();
        }

        private static String asString(MethodInfo methodInfo) {
            return new StringJoiner(", ", MethodInfo.class.getSimpleName() + "[", "]").add("qualifier=" + methodInfo.qualifier()).add("auth=" + methodInfo.isSecured()).toString();
        }

        private static String asString(ServiceInfo serviceInfo) {
            return new StringJoiner(", ", ServiceMethodInvoker.class.getSimpleName() + "[", "]").add("serviceInstance=" + serviceInfo.serviceInstance()).add("tags=" + serviceInfo.tags()).toString();
        }
    }

    public static interface MonitorMBean {
        public String getServiceEndpoint();

        public String getAllServiceEndpoints();

        public String getServiceMethodInvokers();

        public String getServiceInfos();
    }

    private static class ServiceTransportBootstrap {
        public static final Supplier<ServiceTransport> NULL_SUPPLIER = () -> null;
        public static final ServiceTransportBootstrap NULL_INSTANCE = new ServiceTransportBootstrap();
        private final Supplier<ServiceTransport> transportSupplier;
        private ServiceTransport serviceTransport;
        private ClientTransport clientTransport;
        private ServerTransport serverTransport;
        private Address transportAddress = Address.NULL_ADDRESS;

        public ServiceTransportBootstrap() {
            this(NULL_SUPPLIER);
        }

        public ServiceTransportBootstrap(Supplier<ServiceTransport> transportSupplier) {
            this.transportSupplier = transportSupplier;
        }

        private Mono<ServiceTransportBootstrap> start(Microservices microservices) {
            if (this.transportSupplier == NULL_SUPPLIER || (this.serviceTransport = this.transportSupplier.get()) == null) {
                return Mono.just((Object)NULL_INSTANCE);
            }
            return this.serviceTransport.start().doOnSuccess(transport -> {
                this.serviceTransport = transport;
            }).flatMap(transport -> this.serviceTransport.serverTransport(microservices.methodRegistry).bind()).doOnSuccess(transport -> {
                this.serverTransport = transport;
            }).map(transport -> {
                this.transportAddress = ServiceTransportBootstrap.prepareAddress(this.serverTransport.address());
                this.clientTransport = this.serviceTransport.clientTransport();
                return this;
            }).doOnSubscribe(s -> LOGGER.info("[{}][serviceTransport][start] Starting", (Object)microservices.id())).doOnSuccess(transport -> LOGGER.info("[{}][serviceTransport][start] Started, address: {}", (Object)microservices.id(), (Object)this.serverTransport.address())).doOnError(ex -> LOGGER.error("[{}][serviceTransport][start] Exception occurred: {}", (Object)microservices.id(), (Object)ex.toString()));
        }

        private static Address prepareAddress(Address address) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(address.host());
            }
            catch (UnknownHostException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            if (inetAddress.isAnyLocalAddress()) {
                return Address.create((String)Address.getLocalIpAddress().getHostAddress(), (int)address.port());
            }
            return Address.create((String)inetAddress.getHostAddress(), (int)address.port());
        }

        private Mono<Void> shutdown() {
            return Mono.defer(() -> Flux.concatDelayError((Publisher[])new Publisher[]{(Publisher)Optional.ofNullable(this.serverTransport).map(ServerTransport::stop).orElse(Mono.empty()), (Publisher)Optional.ofNullable(this.serviceTransport).map(ServiceTransport::stop).orElse(Mono.empty())}).then());
        }
    }

    private static class GatewayBootstrap {
        private final List<Function<GatewayOptions, Gateway>> factories = new ArrayList<Function<GatewayOptions, Gateway>>();
        private final List<Gateway> gateways = new CopyOnWriteArrayList<Gateway>();

        private GatewayBootstrap() {
        }

        private GatewayBootstrap addFactory(Function<GatewayOptions, Gateway> factory) {
            this.factories.add(factory);
            return this;
        }

        private Mono<GatewayBootstrap> start(Microservices microservices, GatewayOptions options) {
            return Flux.fromIterable(this.factories).flatMap(factory -> {
                Gateway gateway = (Gateway)factory.apply(options);
                return gateway.start().doOnSuccess(this.gateways::add).doOnSubscribe(s -> LOGGER.info("[{}][gateway][{}][start] Starting", (Object)microservices.id(), (Object)gateway.id())).doOnSuccess(gateway1 -> LOGGER.info("[{}][gateway][{}][start] Started, address: {}", new Object[]{microservices.id(), gateway1.id(), gateway1.address()})).doOnError(ex -> LOGGER.error("[{}][gateway][{}][start] Exception occurred: {}", new Object[]{microservices.id(), gateway.id(), ex.toString()}));
            }).then(Mono.just((Object)this));
        }

        private Mono<Void> shutdown() {
            return Mono.whenDelayError((Publisher[])((Publisher[])this.gateways.stream().map(Gateway::stop).toArray(Mono[]::new)));
        }

        private List<Gateway> gateways() {
            return new ArrayList<Gateway>(this.gateways);
        }

        private Gateway gateway(String id) {
            return this.gateways.stream().filter(gateway -> gateway.id().equals(id)).findFirst().orElseThrow(() -> new IllegalArgumentException("Didn't find gateway by id=" + id));
        }
    }

    private static class CompositeServiceDiscovery
    implements ServiceDiscovery {
        private final List<UnaryOperator<ServiceDiscoveryOptions>> optionOperators = new ArrayList<UnaryOperator<ServiceDiscoveryOptions>>();
        private final Map<String, ServiceDiscovery> discoveryInstances = new ConcurrentHashMap<String, ServiceDiscovery>();
        private final Map<String, ServiceDiscoveryContext> discoveryContexts = new ConcurrentHashMap<String, ServiceDiscoveryContext>();
        private final Sinks.Many<ServiceDiscoveryEvent> sink = Sinks.many().multicast().directBestEffort();
        private final Disposable.Composite disposables = Disposables.composite();
        private Scheduler scheduler;
        private Microservices microservices;

        private CompositeServiceDiscovery() {
        }

        private CompositeServiceDiscovery addOperator(UnaryOperator<ServiceDiscoveryOptions> operator) {
            this.optionOperators.add(operator);
            return this;
        }

        private Mono<ServiceDiscovery> createInstance(Microservices microservices, ServiceDiscoveryOptions options) {
            this.microservices = microservices;
            this.scheduler = Schedulers.newSingle((String)"composite-discovery", (boolean)true);
            for (UnaryOperator<ServiceDiscoveryOptions> operator : this.optionOperators) {
                ServiceDiscoveryOptions finalOptions = (ServiceDiscoveryOptions)operator.apply(options);
                String id = finalOptions.id();
                ServiceEndpoint serviceEndpoint = finalOptions.serviceEndpoint();
                ServiceDiscovery serviceDiscovery = finalOptions.discoveryFactory().createServiceDiscovery(serviceEndpoint);
                this.discoveryInstances.put(id, serviceDiscovery);
                this.discoveryContexts.put(id, ServiceDiscoveryContext.builder().id(id).address(Address.NULL_ADDRESS).discovery(serviceDiscovery).serviceRegistry(microservices.serviceRegistry).scheduler(this.scheduler).build());
            }
            return Mono.just((Object)this);
        }

        private Mono<Void> startListen() {
            return this.start().doOnSubscribe(s -> LOGGER.info("[{}][startListen] Starting", (Object)this.microservices.id())).doOnSuccess(avoid -> LOGGER.info("[{}][startListen] Started", (Object)this.microservices.id())).doOnError(ex -> LOGGER.error("[{}][startListen] Exception occurred: {}", (Object)this.microservices.id(), (Object)ex.toString()));
        }

        public Flux<ServiceDiscoveryEvent> listen() {
            return Flux.fromStream(this.microservices.serviceRegistry.listServiceEndpoints().stream()).map(ServiceDiscoveryEvent::newEndpointAdded).concatWith((Publisher)this.sink.asFlux().onBackpressureBuffer()).subscribeOn(this.scheduler).publishOn(this.scheduler);
        }

        public Mono<Void> start() {
            return Flux.fromIterable(this.discoveryInstances.entrySet()).flatMap(entry -> {
                String id = (String)entry.getKey();
                ServiceDiscovery discovery = (ServiceDiscovery)entry.getValue();
                return this.start0(id, discovery).doOnSubscribe(s -> LOGGER.info("[discovery][{}][start] Starting", (Object)id)).doOnSuccess(avoid -> LOGGER.info("[discovery][{}][start] Started", (Object)id)).doOnError(ex -> LOGGER.error("[discovery][{}][start] Exception occurred: {}", (Object)id, (Object)ex.toString()));
            }).then();
        }

        private Mono<? extends Void> start0(String id, ServiceDiscovery discovery) {
            ServiceDiscoveryContext.Builder discoveryContextBuilder = ServiceDiscoveryContext.from((ServiceDiscoveryContext)this.discoveryContexts.get(id));
            this.disposables.add(discovery.listen().subscribeOn(this.scheduler).publishOn(this.scheduler).doOnNext(event -> this.onDiscoveryEvent(this.microservices, (ServiceDiscoveryEvent)event)).doOnNext(event -> this.sink.emitNext(event, (Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED)).subscribe());
            return Mono.deferContextual(context -> discovery.start()).doOnSuccess(avoid -> this.discoveryContexts.put(id, discoveryContextBuilder.build())).contextWrite(context -> context.put(ServiceDiscoveryContext.Builder.class, (Object)discoveryContextBuilder));
        }

        private void onDiscoveryEvent(Microservices microservices, ServiceDiscoveryEvent event) {
            if (event.isEndpointAdded()) {
                microservices.serviceRegistry.registerService(event.serviceEndpoint());
            }
            if (event.isEndpointLeaving() || event.isEndpointRemoved()) {
                microservices.serviceRegistry.unregisterService(event.serviceEndpoint().id());
            }
        }

        public Mono<Void> shutdown() {
            return Mono.defer(() -> {
                this.disposables.dispose();
                this.sink.emitComplete((Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED);
                return Mono.whenDelayError((Iterable)this.discoveryInstances.values().stream().map(ServiceDiscovery::shutdown).collect(Collectors.toList())).then(Mono.fromRunnable(() -> this.scheduler.dispose()));
            });
        }
    }

    public static final class Builder {
        private Map<String, String> tags = new HashMap<String, String>();
        private final List<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
        private ServiceRegistry serviceRegistry = new ServiceRegistryImpl();
        private ServiceMethodRegistry methodRegistry = new ServiceMethodRegistryImpl();
        private Authenticator<Object> defaultAuthenticator = null;
        private final CompositeServiceDiscovery compositeDiscovery = new CompositeServiceDiscovery();
        private ServiceTransportBootstrap transportBootstrap = new ServiceTransportBootstrap();
        private final GatewayBootstrap gatewayBootstrap = new GatewayBootstrap();
        private ServiceProviderErrorMapper defaultErrorMapper = DefaultErrorMapper.INSTANCE;
        private ServiceMessageDataDecoder defaultDataDecoder = Optional.ofNullable(ServiceMessageDataDecoder.INSTANCE).orElse((message, dataType) -> message);
        private String defaultContentType = "application/json";
        private PrincipalMapper<Object, Object> defaultPrincipalMapper = null;
        private String externalHost;
        private Integer externalPort;

        public Mono<Microservices> start() {
            return Mono.defer(() -> new Microservices(this).start());
        }

        public Microservices startAwait() {
            return (Microservices)this.start().block();
        }

        public Builder services(ServiceInfo ... services) {
            this.serviceProviders.add(call -> Arrays.stream(services).collect(Collectors.toList()));
            return this;
        }

        public Builder services(Object ... services) {
            this.serviceProviders.add(call -> Arrays.stream(services).map(s -> s instanceof ServiceInfo ? (ServiceInfo)s : ServiceInfo.fromServiceInstance((Object)s).build()).collect(Collectors.toList()));
            return this;
        }

        public Builder services(ServiceProvider serviceProvider) {
            this.serviceProviders.add(serviceProvider);
            return this;
        }

        public Builder externalHost(String externalHost) {
            this.externalHost = externalHost;
            return this;
        }

        public Builder externalPort(Integer externalPort) {
            this.externalPort = externalPort;
            return this;
        }

        public Builder serviceRegistry(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            return this;
        }

        public Builder methodRegistry(ServiceMethodRegistry methodRegistry) {
            this.methodRegistry = methodRegistry;
            return this;
        }

        public Builder discovery(ServiceDiscoveryFactory discoveryFactory) {
            return this.discovery("default", discoveryFactory);
        }

        public Builder discovery(String id, ServiceDiscoveryFactory discoveryFactory) {
            this.compositeDiscovery.addOperator(opts -> opts.id(id).discoveryFactory(discoveryFactory));
            return this;
        }

        public Builder transport(Supplier<ServiceTransport> supplier) {
            this.transportBootstrap = new ServiceTransportBootstrap(supplier);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder gateway(Function<GatewayOptions, Gateway> factory) {
            this.gatewayBootstrap.addFactory(factory);
            return this;
        }

        public Builder defaultErrorMapper(ServiceProviderErrorMapper errorMapper) {
            this.defaultErrorMapper = Objects.requireNonNull(errorMapper, "default errorMapper");
            return this;
        }

        public Builder defaultDataDecoder(ServiceMessageDataDecoder dataDecoder) {
            this.defaultDataDecoder = Objects.requireNonNull(dataDecoder, "default dataDecoder");
            return this;
        }

        public Builder defaultContentType(String contentType) {
            this.defaultContentType = Objects.requireNonNull(contentType, "default contentType");
            return this;
        }

        public <T> Builder defaultAuthenticator(Authenticator<? extends T> authenticator) {
            this.defaultAuthenticator = authenticator;
            return this;
        }

        public <T, R> Builder defaultPrincipalMapper(PrincipalMapper<? super T, ? extends R> principalMapper) {
            this.defaultPrincipalMapper = principalMapper;
            return this;
        }
    }
}

