/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.transport.api;

import io.scalecube.cluster.transport.api.MessageCodec;
import reactor.core.Exceptions;

public final class TransportConfig
implements Cloneable {
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    public static final int DEFAULT_WAN_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_LOCAL_CONNECT_TIMEOUT = 1000;
    private int port = 0;
    private int connectTimeout = 3000;
    private MessageCodec messageCodec = MessageCodec.INSTANCE;
    private int maxFrameLength = 0x200000;

    public static TransportConfig defaultConfig() {
        return new TransportConfig();
    }

    public static TransportConfig defaultLanConfig() {
        return TransportConfig.defaultConfig();
    }

    public static TransportConfig defaultWanConfig() {
        return TransportConfig.defaultConfig().connectTimeout(10000);
    }

    public static TransportConfig defaultLocalConfig() {
        return TransportConfig.defaultConfig().connectTimeout(1000);
    }

    public int port() {
        return this.port;
    }

    public TransportConfig port(int port) {
        TransportConfig t = this.clone();
        t.port = port;
        return t;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public TransportConfig connectTimeout(int connectTimeout) {
        TransportConfig t = this.clone();
        t.connectTimeout = connectTimeout;
        return t;
    }

    public MessageCodec messageCodec() {
        return this.messageCodec;
    }

    public TransportConfig messageCodec(MessageCodec messageCodec) {
        TransportConfig t = this.clone();
        t.messageCodec = messageCodec;
        return t;
    }

    public int maxFrameLength() {
        return this.maxFrameLength;
    }

    public TransportConfig maxFrameLength(int maxFrameLength) {
        TransportConfig t = this.clone();
        t.maxFrameLength = maxFrameLength;
        return t;
    }

    public TransportConfig clone() {
        try {
            return (TransportConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String toString() {
        return "TransportConfig{port=" + this.port + ", connectTimeout=" + this.connectTimeout + ", messageCodec=" + this.messageCodec + ", maxFrameLength=" + this.maxFrameLength + '}';
    }
}

