/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.transport.api;

import io.scalecube.net.Address;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public final class Message
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String HEADER_QUALIFIER = "q";
    public static final String HEADER_CORRELATION_ID = "cid";
    public static final String HEADER_SENDER = "sender";
    private Map<String, String> headers = Collections.emptyMap();
    private Object data;

    public Message() {
    }

    private Message(Builder builder) {
        this.data = builder.data;
        this.headers = Collections.unmodifiableMap(Objects.requireNonNull(builder.headers));
    }

    public static Message fromData(Object data) {
        return Message.withData(data).build();
    }

    public static Builder withData(Object data) {
        return Message.builder().data(data);
    }

    public static Message fromHeaders(Map<String, String> headers) {
        return Message.withHeaders(headers).build();
    }

    public static Builder withHeaders(Map<String, String> headers) {
        return Message.builder().headers(headers);
    }

    public static Message fromQualifier(String qualifier) {
        return Message.withQualifier(qualifier).build();
    }

    public static Builder withQualifier(String qualifier) {
        return Message.builder().qualifier(qualifier);
    }

    public static Message from(Message message) {
        return Message.with(message).build();
    }

    public static Builder with(Message message) {
        return Message.withData(message.data).headers(message.headers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public String qualifier() {
        return this.header(HEADER_QUALIFIER);
    }

    public String correlationId() {
        return this.header(HEADER_CORRELATION_ID);
    }

    public <T> T data() {
        return (T)this.data;
    }

    public Address sender() {
        return Optional.ofNullable(this.header(HEADER_SENDER)).map(Address::from).orElse(null);
    }

    public String toString() {
        return new StringJoiner(", ", Message.class.getSimpleName() + "[", "]").add("headers=" + this.headers).add("data=" + this.data).toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.headers.size());
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            out.writeUTF(header.getKey());
            out.writeUTF(header.getValue());
        }
        out.writeObject(this.data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int headersSize = in.readInt();
        HashMap<String, String> headers = new HashMap<String, String>(headersSize);
        for (int i = 0; i < headersSize; ++i) {
            String name = in.readUTF();
            String value = in.readUTF();
            headers.put(name, value);
        }
        this.headers = Collections.unmodifiableMap(headers);
        this.data = in.readObject();
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Object data;

        private Builder() {
        }

        private Object data() {
            return this.data;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        private Map<String, String> headers() {
            return this.headers;
        }

        public Builder headers(Map<String, String> headers) {
            headers.forEach(this::header);
            return this;
        }

        public Builder header(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.headers.put(key, value);
            return this;
        }

        public Builder qualifier(String qualifier) {
            return this.header(Message.HEADER_QUALIFIER, qualifier);
        }

        public Builder correlationId(String correlationId) {
            return this.header(Message.HEADER_CORRELATION_ID, correlationId);
        }

        public Builder sender(Address sender) {
            return this.header(Message.HEADER_SENDER, sender.toString());
        }

        public Message build() {
            return new Message(this);
        }
    }
}

