package io.sealights.onpremise.agents.plugin;

import java.util.Map;

import org.apache.maven.plugins.annotations.Mojo;

import io.sealights.plugins.engine.api.PluginParameters.BldScanrParams;

/**
 * Runs the Build Scanner.
 *
 * @phase process-classes
 * @goal build-scanner
 * @threadSafe
 * @since 1.0.0
 */
@Mojo(name = "scanner")
public class BldScanrMojo extends SeaLightsMojo {


    /**
     * Flag to enable exit with non zero error code in case of scanning failure.
     *
     * @parameter property="enableNoneZeroErrorCode" default-value="true"
     */
    private boolean enableNoneZeroErrorCode;

    /**
     * If set, run over the packagesincluded property.
     *
     * @parameter property="buildScannerPackagesincluded"
     */
    private String buildScannerPackagesincluded;

    /**
     * If set, run over the packagesexcluded property.
     *
     * @parameter property="buildScannerPackagesexcluded"
     */
    private String buildScannerPackagesexcluded;

    /**
     * Jvm params for buildScanner.
     *
     * @parameter property="buildScannerParams"
     *
     * */
    private Map<String,?> buildScannerParams;

	/**
	 * Flag to disable build scanner logs in spite of common logEnabled=true
	 *
	 * @parameter property="buildScannerIgnoreLogEnabled" default-value="false"
	 */
    private boolean buildScannerIgnoreLogEnabled;
    
 	@Override
	public void initParams() {
		super.initParams();
		BldScanrParams bldScanrParams = new BldScanrParams();
		bldScanrParams.setEnableNoneZeroErrorCode(enableNoneZeroErrorCode);
		bldScanrParams.setBuildScannerPackagesincluded(buildScannerPackagesincluded);
		bldScanrParams.setBuildScannerPackagesexcluded(buildScannerPackagesexcluded);
		bldScanrParams.setBuildScannerParams(buildScannerParams);
		bldScanrParams.setBuildScannerIgnoreLogEnabled(buildScannerIgnoreLogEnabled);
		getParams().setBldScanrParams(bldScanrParams);
	}
 	
	@Override
 	protected boolean executePluginGoal() {
		if (isProjectWithPomPackaging()) {
			getLogger().info("skip scanning for module '{}' with packaging 'pom'", getModuleName());
			return true;
		}
 		return getPluginEngine().executeBldScanrGoal(this).isOk();
 	}
 	
 	@Override
 	protected String getMojoName() {
 		return "build scanner";
 	}

	private boolean isProjectWithPomPackaging() {
		return POM_PACKAGING_VALUE.equals(getProject().getPackaging());
	}
	
}
