package io.sealights.onpremise.agents.plugin;

import java.util.Map;

import io.sealights.onpremise.agents.plugin.MavenEventsListener.FailedProjectInfo;

/**
 * Removes special charactres from the maven raw failures messages
 * 
 * @author ala schneider   Nov 23, 2018
 *
 */
public class BuildFailureFormatter {
	public final static String SPECIAL_CHAR = "\u001B[";
	public final static String EOF_LINE = "\n";
	private final static String EOF_SPECIAL_CHAR = "m";
	
	public static String format(String rawString) {
		String converted = rawString;
		for (;;) {
			String tmp = extractNextSpecialChar(converted);
			if (tmp==null) break;
			else converted = tmp;
		}
		return converted.replace(EOF_LINE, "");
	}
	
	public static String collectFailures(FailedProjectInfo buildFailure, Map<String, FailedProjectInfo> projectsFailures) {
		if (projectsFailures.isEmpty()) {
			return buildFailure.reason;
		}
		
		StringBuilder builder = new StringBuilder();
		builder.append(buildFailure.reason).append(": {" );
		int ctr = 0;
		int last = projectsFailures.size() -1;
		
		for (String pname: projectsFailures.keySet()) {
			builder.append(String.format("\nproject:'%s', failure: '%s'", pname, projectsFailures.get(pname).reason));
			if (ctr<last) {
				builder.append("; ");
			}
			ctr++;
		}
		builder.append("\n}");
		return builder.toString();				
	}
	
	private static String extractNextSpecialChar(String rawString) {
		int startPos = rawString.indexOf(SPECIAL_CHAR);
		if (startPos == -1) {
			return null;
		}
		
		int endPos = rawString.substring(startPos).indexOf(EOF_SPECIAL_CHAR);
		if (endPos == -1) {
			// Invalid case actually; a special character cannot be without 'm' at the end
			// Still in this case the original string will left
			return null;
		}
		
		else { 
			return rawString.substring(0,  startPos) + rawString.substring(startPos + endPos+1);
		}
	}
}