package io.sealights.onpremise.agents.plugin;

import org.apache.maven.plugins.annotations.Mojo;

/**
 * The purpose of this step is to set the ground for the test listener setup.
 * Currently, it is being used to skip JaCoCo in order to avoid collision between the agents.
 *
 * @phase validate
 * @goal prepare-test-listener
 * @threadSafe
 * @since 1.0.0
 */
@Mojo(name = "prepare-listener")
public class PrepareListenerMojo extends SeaLightsMojo {

	@Override
	protected boolean executePluginGoal() {
		return getPluginEngine().executePreLisnrGoal(this).isOk();
	}

	@Override
	protected String getMojoName() {
		return "prepare test listener";
	}

}

