package io.sealights.onpremise.agents.plugin.jacoco;

import io.sealights.onpremise.agents.plugin.PluginConfigurationParser;
import lombok.experimental.UtilityClass;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@UtilityClass
public class JacocoPluginHandler {
    public static final String JACOCO_ARTIFACT_ID = "jacoco-maven-plugin";
    public static final String JACOCO_PROPERTY_NAME = "propertyName";

    public static JacocoPluginConfiguration parse(Plugin plugin) {
        JacocoPluginConfiguration jacocoPluginConfiguration = new JacocoPluginConfiguration();
        if (plugin != null && JACOCO_ARTIFACT_ID.equalsIgnoreCase(plugin.getArtifactId())) {
            Xpp3Dom cfg = PluginConfigurationParser.extractConfiguration(plugin);
            String jacocoPropertyName = PluginConfigurationParser.extractStringValue(cfg, JACOCO_PROPERTY_NAME);
            jacocoPluginConfiguration.setPropertyName(jacocoPropertyName);
        }
        return jacocoPluginConfiguration;
    }
}