package io.sealights.onpremise.agents.plugin.surefire;

import static io.sealights.onpremise.agents.plugin.PluginConfigurationParser.extractBooleanValue;
import static io.sealights.onpremise.agents.plugin.PluginConfigurationParser.extractIntegerValue;
import static io.sealights.onpremise.agents.plugin.PluginConfigurationParser.extractStringValue;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.ARG_LINE;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.FORK_COUNT;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.FORK_MODE;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.PARALLEL;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.REUSE_FORKS;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.SKIP;
import static io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration.THREAD_COUNT;
import static java.lang.Boolean.FALSE;

import io.sealights.onpremise.agents.plugin.PluginConfigurationParser;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

import lombok.experimental.UtilityClass;

@UtilityClass
public class PluginCfgParser {
 	
	/**
	 * Looks for selected arguments of surefire/failsafe plugin configuration
	 * and updates the provided surefireConfig
	 * If exception happens on attempt to retrieve some of the values, 
	 * a partial result will be collected
	 * Note: if the surefire plugin is not defined explicitly in pom, the maven uses the default
	 * version 2.12.4, which does not support 'configuration; element in pom
	 */
	public static PluginConfiguration parse(Plugin plugin, PluginConfiguration pluginConfig) {
		Xpp3Dom cfg = PluginConfigurationParser.extractConfiguration(plugin);
        if (cfg != null) {
			pluginConfig.setArgLine(extractStringValue(cfg, ARG_LINE));
			pluginConfig.setSkip(extractBooleanValue(cfg, SKIP, FALSE));
			pluginConfig.setReuseForks(extractBooleanValue(cfg, REUSE_FORKS));
			pluginConfig.setForkCount(extractIntegerValue(cfg, FORK_COUNT));
			pluginConfig.setThreadCount(extractIntegerValue(cfg, THREAD_COUNT));
			pluginConfig.setForkMode(extractStringValue(cfg, FORK_MODE));
			pluginConfig.setParallel(extractStringValue(cfg, PARALLEL));
		}
		return pluginConfig;
	}
}