/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine;

import io.sealights.onpremise.agentevents.eventservice.proxy.api.AgentEventRequest;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.AgentEventServiceProxy;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.AgentType;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.EndBuildEventRequest;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import org.slf4j.Logger;

public class AgentEventServiceHandler
extends SLServiceProxy
implements AgentEventServiceProxy {
    public static final String ROOT = "/v3/agents";
    public static final String BUILD_END_URL = "/v3/agents/buildend";
    public static final String AGENT_EVENT_URL = "/v3/agents/agent-events";
    private static final String RESULT_MSG_FMT = "%s event(s):[%s], agent:'%s'";
    private static int MAX_ATTEMPTS = 12;
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final Logger LOG = LogFactory.getLogger(AgentEventServiceHandler.class);
    private int httpMaxAttemptsSysPropValue = -1;

    public AgentEventServiceHandler(String token, String server, String proxyConfig) {
        super(token, server, proxyConfig);
    }

    @Override
    public boolean sendAgentEvents(AgentType agentType, AgentEventRequest eventsRequest) {
        return this.postRequest(agentType, eventsRequest);
    }

    @Override
    public boolean sendBuildEndEvent(EndBuildEventRequest requestData) {
        SLHttpResult<Void> slResult = this.getHttpClient().sendPostRequest(new SLHttpRequest<Void>(this.getTag(), this.getServer() + BUILD_END_URL, requestData, Void.class));
        return slResult.isStatusCodeOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postRequest(AgentType agentType, AgentEventRequest requestData) {
        this.logDbgMsg(agentType, String.format("sending event(s):[%s], agent:'%s' ...", new Object[]{requestData.toStringEventsCompact(), agentType}));
        this.setMaxRetriesPropertyValue();
        try {
            SLHttpResult<Void> slResult = this.getHttpClient().sendPostRetry(new SLHttpRequest<Void>(this.getTag(), this.getServer() + AGENT_EVENT_URL, requestData, Void.class));
            if (slResult.isStatusCodeOk()) {
                this.logOkResult(agentType, requestData);
            } else {
                this.logErrorResult(agentType, requestData, null);
            }
            boolean bl = slResult.isStatusCodeOk();
            return bl;
        }
        catch (Exception e) {
            this.logErrorResult(agentType, requestData, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.restoreMaxRetriesPropertyValue();
        }
    }

    protected void setMaxRetriesPropertyValue() {
        this.httpMaxAttemptsSysPropValue = SLHttpConfiguration.getMaxAttempts();
        int eventsMaxAttempts = SystemPropertiesHelper.getIntProperty("sl.agentEventsMaxAttempts", MAX_ATTEMPTS);
        SystemPropertiesHelper.setProperty("sl.httpMaxAttempts", eventsMaxAttempts);
    }

    protected void restoreMaxRetriesPropertyValue() {
        if (this.httpMaxAttemptsSysPropValue == Integer.MIN_VALUE) {
            System.clearProperty("sl.httpMaxAttempts");
        } else {
            SystemPropertiesHelper.setProperty("sl.httpMaxAttempts", this.httpMaxAttemptsSysPropValue);
        }
    }

    protected void logOkResult(AgentType agentType, AgentEventRequest request) {
        String msg = String.format(RESULT_MSG_FMT, new Object[]{"sent successfully", request.toStringEventsCompact(), agentType});
        this.logDbgMsg(agentType, msg);
    }

    protected void logErrorResult(AgentType agentType, AgentEventRequest request, Exception e) {
        String msg = String.format(RESULT_MSG_FMT, new Object[]{"failed to sent", request.toStringEventsCompact(), agentType});
        if (e != null) {
            this.logErrorMsg(agentType, msg, e);
        } else {
            this.logErrorMsg(agentType, msg);
        }
    }

    protected void logDbgMsg(AgentType agentType, String msg) {
        if (agentType.isPluginAgent()) {
            CONSOLE_LOG.debug(msg);
        } else {
            LOG.debug(msg);
        }
    }

    protected void logErrorMsg(AgentType agentType, String msg) {
        if (agentType.isPluginAgent()) {
            CONSOLE_LOG.error(msg);
        } else {
            LOG.error(msg);
        }
    }

    protected void logErrorMsg(AgentType agentType, String msg, Exception e) {
        if (agentType.isPluginAgent()) {
            CONSOLE_LOG.error(msg, e);
        } else {
            LOG.error(msg, (Throwable)e);
        }
    }

    @Override
    public String getTag() {
        return "ES";
    }
}

