/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine;

import io.sealights.onpremise.agentevents.engine.AgentDescriptor;
import io.sealights.onpremise.agentevents.engine.AgentEventAggregator;
import io.sealights.onpremise.agentevents.engine.AgentEventServiceHandler;
import io.sealights.onpremise.agentevents.engine.AgentInputRequests;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.AgentEventRequest;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.EndBuildEventRequest;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartedEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.EventTypes;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.PingDataEvents;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.threads.TaskScheduler;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class AgentEventsDispatcher
implements TaskScheduler.Task {
    private static final Logger LOG = LogFactory.getLogger(AgentEventsDispatcher.class);
    private static final String AGENT_EVENTS = "agent-events";
    static final int EVENTS_INTERVAL_MSECS = 10000;
    private static final int ZERO = 0;
    private List<AgentEvent> eventsBuffer = new ArrayList<AgentEvent>();
    private String agentId;
    private AgentDescriptor agentDescriptor;
    private final AgentEventServiceHandler eventServiceProxy;
    private final TaskScheduler taskScheduler;
    private EndOfBuildSend endOfBuildSend = new EndOfBuildSend();
    private int timerInterval = 10000;
    private AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private Set<AgentEventAggregator<AgentEvent, AgentEvent>> agentEventAggregators = new LinkedHashSet<AgentEventAggregator<AgentEvent, AgentEvent>>();

    public AgentEventsDispatcher(String agentId, AgentDescriptor agentDescriptor, AgentEventServiceHandler eventServiceProxy, TaskScheduler taskScheduler) {
        this.agentId = agentId;
        this.agentDescriptor = agentDescriptor;
        this.taskScheduler = taskScheduler;
        this.eventServiceProxy = eventServiceProxy;
    }

    public AgentEventsDispatcher(String agentId, AgentDescriptor agentDescriptor, AgentEventServiceHandler eventServiceProxy) {
        this(agentId, agentDescriptor, eventServiceProxy, new TaskScheduler(AGENT_EVENTS));
    }

    public void sendStartEvent(AgentStartedEvent agentStartEvent) {
        LOG.info("Handling agentStart ...");
        this.handleUrgentEvent(agentStartEvent, false);
    }

    public void sendShutdownEvent(PingDataEvents.AgentShutdownEvent agentShutdownEvent) {
        LOG.info("Handling agentShutdown ...");
        this.handleUrgentEvent(agentShutdownEvent, true);
    }

    public void stop() {
        this.taskScheduler.stop();
        this.isShuttingDown.set(true);
    }

    public synchronized void addEvent(AgentEvent event) {
        this.eventsBuffer.add(event);
        if (!this.isShuttingDown.get() && !this.taskScheduler.hasTaskAssigned()) {
            this.scheduleSend(this.timerInterval, this.timerInterval);
            LOG.info("Timer scheduled ");
        }
    }

    public synchronized boolean sendBuildEndEvent(EndBuildEventRequest endBuildRequest) {
        return this.endOfBuildSend.execute(this.eventServiceProxy, endBuildRequest);
    }

    @Override
    public String getName() {
        return AGENT_EVENTS;
    }

    @Override
    public void run() {
        this.sendEvents();
    }

    public synchronized void handleUrgentEvent(AgentEvent event, boolean shutdown) {
        this.eventsBuffer.add(event);
        this.sendImmedaitely(shutdown);
    }

    protected void sendImmedaitely(boolean shutdown) {
        this.taskScheduler.cancelTask();
        if (shutdown) {
            this.sendEvents();
        } else {
            this.scheduleSend(0, this.timerInterval);
        }
    }

    protected synchronized void sendEvents() {
        ArrayList<AgentEvent> eventsToSend = new ArrayList<AgentEvent>(this.eventsBuffer);
        this.eventsBuffer.clear();
        List<AgentEvent> aggregateEvents = this.aggregateEvents(eventsToSend);
        if (!aggregateEvents.isEmpty()) {
            LOG.info("Sending {} accumulated events ...", (Object)aggregateEvents.size());
            AgentEventRequest request = new AgentEventRequest(new AgentInputRequests.AgentIdRequest(this.agentId, this.agentDescriptor), aggregateEvents);
            this.eventServiceProxy.sendAgentEvents(this.agentDescriptor.getAgentType(), request);
        }
    }

    protected void scheduleSend(int delayMS, int interval) {
        this.taskScheduler.assignTaskForRepeatedExecution(this, delayMS, interval);
    }

    public void registerAgentEventAggregator(AgentEventAggregator<? extends AgentEvent, ? extends AgentEvent> agentEventAggregator) {
        this.agentEventAggregators.add(agentEventAggregator);
    }

    private boolean addEventForAggregation(AgentEvent agentEvent) {
        return this.agentEventAggregators.stream().map(aggregator -> aggregator.addEvent(agentEvent)).distinct().anyMatch(Boolean.TRUE::equals);
    }

    private List<AgentEvent> aggregateEvents(List<AgentEvent> agentEvents) {
        ArrayList<AgentEvent> aggregatedEvents = new ArrayList<AgentEvent>();
        agentEvents.stream().filter(ae -> !this.addEventForAggregation((AgentEvent)ae)).forEach(aggregatedEvents::add);
        this.agentEventAggregators.forEach(aggregator -> aggregatedEvents.addAll(aggregator.aggregate()));
        return aggregatedEvents;
    }

    public static class EndOfBuildSend {
        public boolean execute(AgentEventServiceHandler eventServiceProxy, EndBuildEventRequest endBuildRequest) {
            boolean result = false;
            try {
                result = eventServiceProxy.sendBuildEndEvent(endBuildRequest);
                LOG.info("{} event {}", (Object)EventTypes.buildEnd, (Object)(result ? " was sent successfully" : " send failed"));
            }
            catch (Exception e) {
                LOG.info("failed to sent '{}' event due to error '{}'", (Object)EventTypes.buildEnd, (Object)this.toStringError(e));
            }
            return result;
        }

        private String toStringError(Exception e) {
            if (StringUtils.isNotEmpty(e.getMessage())) {
                return e.getMessage();
            }
            return e.getClass().getName();
        }
    }
}

