/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine.builders;

import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class CredentialsMaskFormatter {
    public static final String MASK = "";
    public static final String PASSWORD = "password";
    public static final String TOKEN = "token";
    public static final String PROXY = "proxy";
    public static final String USER = "user";
    private static final String ASSIGN = "=";

    public static String maskArgValue(String originalValue) {
        return CredentialsMaskFormatter.argumentValueMustBeMasked(originalValue) || CredentialsMaskFormatter.isPotentialSensitive(originalValue) ? CredentialsMaskFormatter.maskValue(originalValue) : originalValue;
    }

    private static boolean argumentValueMustBeMasked(String argumentName) {
        String lowerCase = argumentName.toLowerCase();
        return lowerCase.contains(PASSWORD) || lowerCase.contains(USER) || lowerCase.contains(TOKEN) || lowerCase.contains(PROXY);
    }

    public static Map<String, String> maskTokenInMapValues(Map<String, String> originalMap) {
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            String lowerCaseKey = entry.getKey().toLowerCase();
            if (!lowerCaseKey.contains(TOKEN)) continue;
            String replaced = TokenValueFormatter.truncateTokenArgValue(entry.getValue());
            originalMap.put(entry.getKey(), replaced);
        }
        return originalMap;
    }

    private static boolean isPotentialSensitive(String originalValue) {
        return !originalValue.startsWith("-javaagent:") && !originalValue.startsWith("-Dsl.") && !originalValue.startsWith("-XX:") && !originalValue.startsWith("-Djdk.") && !originalValue.startsWith("-Djava.");
    }

    public static List<String> maskSimpleListArguments(List<String> args) {
        ArrayList<String> result = new ArrayList<String>(args.size());
        boolean mask = false;
        for (String argv : args) {
            if (mask) {
                result.add(MASK);
                mask = false;
                continue;
            }
            result.add(CredentialsMaskFormatter.maskArgValue(argv));
            mask = argv.startsWith("-") && CredentialsMaskFormatter.argumentValueMustBeMasked(argv);
        }
        return result;
    }

    private static String maskValue(String originalValue) {
        String[] keyValuePair = originalValue.split(ASSIGN);
        if (keyValuePair.length >= 2) {
            return keyValuePair[0] + ASSIGN + MASK;
        }
        return originalValue;
    }

    @Generated
    private CredentialsMaskFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

