/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine.builders;

import java.util.Map;

abstract class InfoBuilder<T> {
    protected T data;

    InfoBuilder() {
    }

    public T build() {
        try {
            this.fillData();
            return this.data;
        }
        catch (Throwable t) {
            return this.getEmptyData();
        }
    }

    public void fetchSystemEnv(SysEnvConsumer consumer) {
        Map<String, String> allEnvVars = System.getenv();
        for (String key : allEnvVars.keySet()) {
            consumer.consume(key, allEnvVars.get(key));
        }
    }

    protected abstract T getEmptyData();

    protected abstract void fillData();

    public static interface SysEnvConsumer {
        public void consume(String var1, String var2);
    }
}

