/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine.builders;

import io.sealights.onpremise.agentevents.engine.builders.InfoBuilder;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.env.JvmEnvInfoCollector;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class MachineInfoBuilder
extends InfoBuilder<AgentStartInfo.MachineInfo> {
    public static final String LOCAL_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    boolean maskSensitiveData = SystemPropertiesHelper.getBoolProperty("sl.maskData", false);

    MachineInfoBuilder() {
        this.data = new AgentStartInfo.MachineInfo();
    }

    @Override
    protected AgentStartInfo.MachineInfo getEmptyData() {
        return (AgentStartInfo.MachineInfo)this.data;
    }

    @Override
    protected void fillData() {
        ((AgentStartInfo.MachineInfo)this.data).setMachineName(this.maskSensitiveData ? "" : JvmEnvInfoCollector.getMachineName());
        ((AgentStartInfo.MachineInfo)this.data).setArch(JvmEnvInfoCollector.getArch());
        ((AgentStartInfo.MachineInfo)this.data).setOs(JvmEnvInfoCollector.getOs());
        this.fillLocalTime();
        ((AgentStartInfo.MachineInfo)this.data).setIpAddress(this.maskSensitiveData ? Collections.singletonList("") : JvmEnvInfoCollector.getIpAddresses());
    }

    private void fillLocalTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        long utcTime = calendar.getTimeInMillis();
        TimeZone localeZone = ((Calendar)calendar).getTimeZone();
        long localTime = utcTime + (long)localeZone.getRawOffset();
        ((AgentStartInfo.MachineInfo)this.data).setLocalDateTimeUnix_s(localTime);
        SimpleDateFormat format = new SimpleDateFormat(LOCAL_TIME_FORMAT);
        format.setTimeZone(localeZone);
        Date now = new Date(utcTime);
        ((AgentStartInfo.MachineInfo)this.data).setLocalDateTime(format.format(now));
    }
}

