/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api;

import io.sealights.onpremise.agentevents.engine.AgentInputRequests;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class AgentEventRequest {
    private String agentId;
    private String buildSessionId;
    private List<AgentEvent> events = new ArrayList<AgentEvent>();

    public AgentEventRequest() {
    }

    public AgentEventRequest(AgentInputRequests.AgentIdRequest idRequest, List<AgentEvent> events) {
        this(idRequest);
        this.events = events;
    }

    public AgentEventRequest(AgentInputRequests.AgentIdRequest idRequest, AgentEvent event) {
        this(idRequest);
        this.events.add(event);
    }

    public AgentEventRequest(String agentId, String buildSessionId, AgentEvent ... agentEvents) {
        this.agentId = agentId;
        this.buildSessionId = buildSessionId;
        this.events = Arrays.asList(agentEvents);
    }

    protected AgentEventRequest(AgentInputRequests.AgentIdRequest idRequest) {
        this.agentId = idRequest.getAgentId();
        this.buildSessionId = idRequest.getBuildSessionId();
    }

    public String toString() {
        return String.format("[agentId=%s, buildSessionId=%s, events=%s]", this.agentId, this.buildSessionId, this.events);
    }

    public String toStringEventsCompact() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int last = this.events.size() - 1;
        for (AgentEvent ev : this.events) {
            builder.append(ev.getType());
            if (i >= last) continue;
            builder.append(", ");
            ++i;
        }
        return builder.toString();
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public String getBuildSessionId() {
        return this.buildSessionId;
    }

    @Generated
    public List<AgentEvent> getEvents() {
        return this.events;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setBuildSessionId(String buildSessionId) {
        this.buildSessionId = buildSessionId;
    }

    @Generated
    public void setEvents(List<AgentEvent> events) {
        this.events = events;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentEventRequest)) {
            return false;
        }
        AgentEventRequest other = (AgentEventRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$buildSessionId = this.getBuildSessionId();
        String other$buildSessionId = other.getBuildSessionId();
        if (this$buildSessionId == null ? other$buildSessionId != null : !this$buildSessionId.equals(other$buildSessionId)) {
            return false;
        }
        List<AgentEvent> this$events = this.getEvents();
        List<AgentEvent> other$events = other.getEvents();
        return !(this$events == null ? other$events != null : !((Object)this$events).equals(other$events));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentEventRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $buildSessionId = this.getBuildSessionId();
        result = result * 59 + ($buildSessionId == null ? 43 : $buildSessionId.hashCode());
        List<AgentEvent> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        return result;
    }
}

