/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api.aggregators;

import io.sealights.onpremise.agentevents.engine.AgentEventAggregator;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CommonDataEventsAggregator<T extends AgentEvent, R extends AgentEvent>
implements AgentEventAggregator<T, R> {
    private final Class<T> eventClass;
    private final Collection<T> agentEvents;
    private final Supplier<R> aggregatedEventProvider;
    private final BiConsumer<Collection<T>, R> aggregationConsumer;

    protected CommonDataEventsAggregator(Class<T> eventClass, Collection<T> agentEventsCollection, Supplier<R> aggregatedEventProvider, BiConsumer<Collection<T>, R> aggregationConsumer) {
        this.eventClass = eventClass;
        this.agentEvents = agentEventsCollection;
        this.aggregatedEventProvider = aggregatedEventProvider;
        this.aggregationConsumer = aggregationConsumer;
    }

    @Override
    public Class<T> getAgentEventClass() {
        return this.eventClass;
    }

    @Override
    public boolean addEvent(T agentEvent) {
        if (this.eventClass.equals(agentEvent.getClass())) {
            this.agentEvents.add(agentEvent);
            return true;
        }
        return false;
    }

    @Override
    public List<R> aggregate() {
        if (this.agentEvents.isEmpty()) {
            return Collections.emptyList();
        }
        AgentEvent aggregatedAgentEvent = (AgentEvent)this.aggregatedEventProvider.get();
        Comparator<AgentEvent> comparator = Comparator.comparing(AgentEvent::getUtcTimestamp_ms);
        List agentEventsToAggregate = this.agentEvents.stream().sorted(comparator).collect(Collectors.toList());
        this.agentEvents.clear();
        this.aggregationConsumer.accept(agentEventsToAggregate, aggregatedAgentEvent);
        AgentEventAggregator.updateAggregatedAgentEventTimestamp(agentEventsToAggregate, aggregatedAgentEvent);
        return Collections.singletonList(aggregatedAgentEvent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonDataEventsAggregator that = (CommonDataEventsAggregator)o;
        return Objects.equals(this.eventClass, that.eventClass);
    }

    public int hashCode() {
        return Objects.hash(this.eventClass);
    }
}

