/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.IAgentEventType;
import lombok.Generated;

public abstract class AgentEvent {
    private IAgentEventType type;
    private long utcTimestamp_ms;

    public AgentEvent() {
        this(null, System.currentTimeMillis());
    }

    public AgentEvent(long currentTimeMs) {
        this(null, currentTimeMs);
    }

    protected AgentEvent(IAgentEventType type) {
        this.type = type;
        this.utcTimestamp_ms = System.currentTimeMillis();
    }

    protected AgentEvent(IAgentEventType type, long currentTimeMs) {
        this.type = type;
        this.utcTimestamp_ms = currentTimeMs;
    }

    public String toString() {
        return String.format("(%s)", this.toStringAttrs());
    }

    protected String toStringAttrs() {
        return String.format("event type=%s, utcTimestamp_ms=%s", this.type, this.utcTimestamp_ms);
    }

    public static AgentEvent modifyTimeStamp(AgentEvent event, long currentTimeMs) {
        event.setUtcTimestamp_ms(currentTimeMs);
        return event;
    }

    @JsonCreator
    public static AgentEvent createByType(@JsonProperty(value="type") IAgentEventType agentEventType) {
        try {
            return agentEventType.getEventClass().newInstance();
        }
        catch (Exception e) {
            return new AgentEvent(){};
        }
    }

    @Generated
    public IAgentEventType getType() {
        return this.type;
    }

    @Generated
    public long getUtcTimestamp_ms() {
        return this.utcTimestamp_ms;
    }

    @Generated
    public void setType(IAgentEventType type) {
        this.type = type;
    }

    @Generated
    public void setUtcTimestamp_ms(long utcTimestamp_ms) {
        this.utcTimestamp_ms = utcTimestamp_ms;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentEvent)) {
            return false;
        }
        AgentEvent other = (AgentEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUtcTimestamp_ms() != other.getUtcTimestamp_ms()) {
            return false;
        }
        IAgentEventType this$type = this.getType();
        IAgentEventType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $utcTimestamp_ms = this.getUtcTimestamp_ms();
        result = result * 59 + (int)($utcTimestamp_ms >>> 32 ^ $utcTimestamp_ms);
        IAgentEventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

