/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api.types;

import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentDataEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.IAgentEventType;
import lombok.Generated;

public class FootprintsQueueOverflowEvent
extends AgentDataEvent<FootprintsQueueOverflowData> {
    public static AgentEventCode EVENT_CODE = AgentEventCode.AGENT_FOOTPRINTS_QUEUE_FULL_SUPERUSER;

    public FootprintsQueueOverflowEvent() {
        super((IAgentEventType)EVENT_CODE, new FootprintsQueueOverflowData());
    }

    public FootprintsQueueOverflowEvent(FootprintsQueueOverflowData data) {
        super((IAgentEventType)EVENT_CODE, data);
    }

    public FootprintsQueueOverflowEvent(FootprintsQueueOverflowData data, long currentTimeMs) {
        super(EVENT_CODE, data, currentTimeMs);
    }

    @Override
    public String toString() {
        return String.format("AgentEventCode=%s, FootprintsQueueOverflowData=%s", EVENT_CODE, ((FootprintsQueueOverflowData)this.data).toString());
    }

    public static class FootprintsQueueOverflowData {
        private int droppedPacketCount;
        private int methodsCount;
        private int lines;
        private int hits;

        public FootprintsQueueOverflowData(int droppedPacketCount, int methodsCount, int lines, int hits) {
            this.droppedPacketCount = droppedPacketCount;
            this.methodsCount = methodsCount;
            this.lines = lines;
            this.hits = hits;
        }

        public void addDroppedPacket(int methodsCount, int lines, int hits) {
            ++this.droppedPacketCount;
            this.methodsCount += methodsCount;
            this.lines += lines;
            this.hits += hits;
        }

        public void clear() {
            this.hits = 0;
            this.lines = 0;
            this.methodsCount = 0;
            this.droppedPacketCount = 0;
        }

        public boolean empty() {
            return this.droppedPacketCount == 0;
        }

        public boolean nonEmpty() {
            return this.droppedPacketCount > 0;
        }

        public FootprintsQueueOverflowData clone() {
            FootprintsQueueOverflowData cloned = new FootprintsQueueOverflowData(this.droppedPacketCount, this.methodsCount, this.lines, this.hits);
            return cloned;
        }

        public String toString() {
            return String.format("droppedPacketSize=%s, methods=%s, lines=%s, hits=%s", this.droppedPacketCount, this.methodsCount, this.lines, this.hits);
        }

        @Generated
        public int getDroppedPacketCount() {
            return this.droppedPacketCount;
        }

        @Generated
        public int getMethodsCount() {
            return this.methodsCount;
        }

        @Generated
        public int getLines() {
            return this.lines;
        }

        @Generated
        public int getHits() {
            return this.hits;
        }

        @Generated
        public void setDroppedPacketCount(int droppedPacketCount) {
            this.droppedPacketCount = droppedPacketCount;
        }

        @Generated
        public void setMethodsCount(int methodsCount) {
            this.methodsCount = methodsCount;
        }

        @Generated
        public void setLines(int lines) {
            this.lines = lines;
        }

        @Generated
        public void setHits(int hits) {
            this.hits = hits;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FootprintsQueueOverflowData)) {
                return false;
            }
            FootprintsQueueOverflowData other = (FootprintsQueueOverflowData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDroppedPacketCount() != other.getDroppedPacketCount()) {
                return false;
            }
            if (this.getMethodsCount() != other.getMethodsCount()) {
                return false;
            }
            if (this.getLines() != other.getLines()) {
                return false;
            }
            return this.getHits() == other.getHits();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FootprintsQueueOverflowData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDroppedPacketCount();
            result = result * 59 + this.getMethodsCount();
            result = result * 59 + this.getLines();
            result = result * 59 + this.getHits();
            return result;
        }

        @Generated
        public FootprintsQueueOverflowData() {
        }
    }
}

