/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenTruncated;
import org.slf4j.Logger;

public class CIProps {
    public static final String CI_PREFIX = "ci.";
    public static final String CI_SL_PROPS_ACTIVE = "ci.sl.propertiesActive";
    private static final String CI_TEST_LISTENER_SHADING_PREFIX = "test.io.sealights.";
    private static Logger LOG = LogFactory.getLogger(CIProps.class);

    public static String toCIPropertyName(String slPropertyName) {
        return CI_PREFIX + slPropertyName;
    }

    public static boolean isCIProperty(String propertyName) {
        return propertyName.startsWith(CI_PREFIX);
    }

    public static String getProperty(String slPropertyName) {
        String actualPropName = CIProps.convertToCIPropertyIfRelevant(slPropertyName);
        if (CIProps.isCIProperty(actualPropName)) {
            LOG.info("Using CI property '{}'", (Object)actualPropName);
        }
        return System.getProperty(actualPropName);
    }

    public static void setProperty(String slPropertyName, String propValue) {
        String actualPropName = CIProps.convertToCIPropertyIfRelevant(slPropertyName);
        if ("sl.token".equals(slPropertyName)) {
            LOG.info("Setting property '{}' to '{}'", (Object)actualPropName, (Object)TokenTruncated.truncate(propValue));
        } else {
            LOG.info("Setting property '{}' to '{}'", (Object)actualPropName, (Object)propValue);
        }
        System.setProperty(actualPropName, propValue);
    }

    public static String convertToCIPropertyIfRelevant(String slPropertyName) {
        if (CIProps.useCIProperties()) {
            return CIProps.toCIPropertyName(slPropertyName);
        }
        return slPropertyName;
    }

    public static boolean useCIProperties() {
        String value = System.getProperty(CI_SL_PROPS_ACTIVE);
        if (value != null && "true".equalsIgnoreCase(value)) {
            return CIProps.class.getName().startsWith(CI_TEST_LISTENER_SHADING_PREFIX);
        }
        return false;
    }
}

