/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.configuration.PropertiesInfo;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertiesFileReader {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    public static void tryReadPropertiesFile() {
        PropertiesFileReader reader = new PropertiesFileReader();
        reader.tryRead();
    }

    private void tryRead() {
        String propertiesPath = "";
        try {
            propertiesPath = System.getProperty("sl.propertiesFile");
            if (propertiesPath == null) {
                return;
            }
            CONSOLE_LOG.info("Found properties file. Path: '" + propertiesPath + "'.");
            List<PropertiesInfo> overrideProps = PropertiesFileReader.mapFileToSystemProps(propertiesPath);
            this.warnForOverridingSysProperties(overrideProps);
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Failed to read properties file due to an error. File: '" + propertiesPath + "', Error:", e);
        }
    }

    private static List<PropertiesInfo> mapFileToSystemProps(String propertiesFile) {
        Properties properties = new Properties();
        FileInputStream input = null;
        ArrayList<PropertiesInfo> overrideProps = new ArrayList<PropertiesInfo>();
        try {
            input = new FileInputStream(propertiesFile);
            properties.load(input);
            for (String property : properties.stringPropertyNames()) {
                String newValue = properties.getProperty(property);
                String oldValue = System.getProperty(property);
                if (oldValue != null) {
                    PropertiesInfo propertiesInfo = new PropertiesInfo(property, oldValue, newValue);
                    overrideProps.add(propertiesInfo);
                }
                System.setProperty(property, newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed while trying to read properties file '" + propertiesFile + "'", e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return overrideProps;
    }

    private void warnForOverridingSysProperties(List<PropertiesInfo> overrideProps) {
        for (PropertiesInfo propertyInfo : overrideProps) {
            CONSOLE_LOG.warn("Overriding system property '" + propertyInfo.getPropertyName() + "' from '" + propertyInfo.getOldValue() + "' to '" + propertyInfo.getNewValue() + "'");
        }
    }
}

