/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.configuration.CIProps;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class SystemPropertiesHelper {
    public static final String DEFAULT_STR_ATTR_VALUE = "";
    public static final boolean DEFAULT_BOOL_ATTR_VALUE = false;
    public static final int DEFAULT_INT_ATTR_VALUE = Integer.MIN_VALUE;

    public static void setProperty(String propName, int value) {
        System.setProperty(propName, Integer.toString(value));
    }

    public static void setProperty(String propName, boolean value) {
        if (value) {
            System.setProperty(propName, "true");
        } else {
            System.setProperty(propName, "false");
        }
    }

    public static String getStrProperty(String propName) {
        return SystemPropertiesHelper.getStrProperty(propName, DEFAULT_STR_ATTR_VALUE);
    }

    public static String getStrProperty(String propName, String attrDefault) {
        String propValue = SystemPropertiesHelper.getProperty(propName);
        if (StringUtils.isNotEmpty(propValue)) {
            return propValue;
        }
        return attrDefault;
    }

    public static String getStrPropertyIfExists(String propName) {
        return SystemPropertiesHelper.getStrProperty(propName, null);
    }

    public static boolean getBoolProperty(String propName) {
        return SystemPropertiesHelper.getBoolProperty(propName, false);
    }

    public static boolean getBoolProperty(String propName, boolean attrDefault) {
        Boolean propValue = SystemPropertiesHelper.getBoolObjectProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return attrDefault;
    }

    public static Boolean getBoolObjectProperty(String propName) {
        String value = SystemPropertiesHelper.getProperty(propName);
        if (value == null || !"false".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value)) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public static int getIntProperty(String propName) {
        return SystemPropertiesHelper.getIntProperty(propName, Integer.MIN_VALUE);
    }

    public static int getIntProperty(String propName, int attrDefault) {
        Integer propValue = SystemPropertiesHelper.getIntObjectProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return attrDefault;
    }

    public static Integer getIntObjectProperty(String propName) {
        String value = SystemPropertiesHelper.getProperty(propName);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getProperty(String slPropertyName) {
        return CIProps.getProperty(slPropertyName);
    }
}

