/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import lombok.Generated;
import org.slf4j.Logger;

public class UpgradeConfiguration {
    private static final Logger LOGGER = LogFactory.getLogger(UpgradeConfiguration.class);
    public static final String FILES_STORAGE_TMP = "/tmp";
    private String token;
    private String customerId;
    private String appName;
    private String environmentName;
    private String branchName;
    private String server;
    private String proxy;
    private String fileStorage;
    private boolean enableUpgrade;

    public UpgradeConfiguration() {
        this.fileStorage = UpgradeConfiguration.resolveDefaultFileStorage();
    }

    public String toString() {
        return String.format("UpgradeConfiguration [token%s, customerId=%s, appName=%s, environmentName=%s, branchName=%s, server=%s, proxy=%s, filesStorage=%s, enableUpgrade=%s]", this.token != null ? "(size=" + this.token.length() + ")" : "=null", this.customerId, this.appName, this.environmentName, this.branchName, this.server, this.proxy, this.fileStorage, this.enableUpgrade);
    }

    public static String resolveDefaultFileStorage() {
        String sysProperty = System.getProperty("java.io.tmpdir");
        LOGGER.debug("System property {}={}", (Object)"java.io.tmpdir", (Object)sysProperty);
        return sysProperty != null ? sysProperty : FILES_STORAGE_TMP;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Generated
    public String getBranchName() {
        return this.branchName;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getProxy() {
        return this.proxy;
    }

    @Generated
    public String getFileStorage() {
        return this.fileStorage;
    }

    @Generated
    public boolean isEnableUpgrade() {
        return this.enableUpgrade;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Generated
    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    @Generated
    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setFileStorage(String fileStorage) {
        this.fileStorage = fileStorage;
    }

    @Generated
    public void setEnableUpgrade(boolean enableUpgrade) {
        this.enableUpgrade = enableUpgrade;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeConfiguration)) {
            return false;
        }
        UpgradeConfiguration other = (UpgradeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableUpgrade() != other.isEnableUpgrade()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$environmentName = this.getEnvironmentName();
        String other$environmentName = other.getEnvironmentName();
        if (this$environmentName == null ? other$environmentName != null : !this$environmentName.equals(other$environmentName)) {
            return false;
        }
        String this$branchName = this.getBranchName();
        String other$branchName = other.getBranchName();
        if (this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        String this$fileStorage = this.getFileStorage();
        String other$fileStorage = other.getFileStorage();
        return !(this$fileStorage == null ? other$fileStorage != null : !this$fileStorage.equals(other$fileStorage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableUpgrade() ? 79 : 97);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $environmentName = this.getEnvironmentName();
        result = result * 59 + ($environmentName == null ? 43 : $environmentName.hashCode());
        String $branchName = this.getBranchName();
        result = result * 59 + ($branchName == null ? 43 : $branchName.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        String $fileStorage = this.getFileStorage();
        result = result * 59 + ($fileStorage == null ? 43 : $fileStorage.hashCode());
        return result;
    }

    @Generated
    public UpgradeConfiguration(String token, String customerId, String appName, String environmentName, String branchName, String server, String proxy, String fileStorage, boolean enableUpgrade) {
        this.token = token;
        this.customerId = customerId;
        this.appName = appName;
        this.environmentName = environmentName;
        this.branchName = branchName;
        this.server = server;
        this.proxy = proxy;
        this.fileStorage = fileStorage;
        this.enableUpgrade = enableUpgrade;
    }
}

