/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration.stringable;

import io.sealights.onpremise.agents.infra.configuration.stringable.PropConverters;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StringableConfiguration {
    public static boolean WITH_CONVERTER = true;
    public static boolean WITHOUT_CONVERTER = false;
    private static final String PRETTY_FORMAT = "%n\t%s";
    private static final String SIMPLE_FORMAT = " %s";
    private static final String KEY_VALUE_FMT = "%s:%s";

    public abstract PropConvertList createPropConverters();

    public String toStringProperties(String title, boolean prettyPrint, boolean useConverter) {
        PropConvertList propConverts;
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotEmpty(title)) {
            builder.append(title).append(": ");
        }
        if ((propConverts = this.createPropConverters()) == null) {
            builder.append("empty");
        } else {
            int last = propConverts.size() - 1;
            int current = 0;
            for (PropConverters.PropertyConverter conv : propConverts) {
                builder.append(this.toStringPropKeyValue(conv, prettyPrint, useConverter));
                if (current < last) {
                    builder.append(",");
                }
                ++current;
            }
        }
        return builder.toString();
    }

    protected String toStringPropKeyValue(PropConverters.PropertyConverter<?> converter, boolean prettyPrint, boolean useConverter) {
        String currentFmt;
        String string = currentFmt = prettyPrint ? PRETTY_FORMAT : SIMPLE_FORMAT;
        if (useConverter) {
            return String.format(currentFmt, converter.convert());
        }
        Object value = converter.getValue();
        String keyAndValue = String.format(KEY_VALUE_FMT, converter.getName(), value != null ? value : "null");
        return String.format(currentFmt, keyAndValue);
    }

    public static class PropConvertList
    extends ArrayList<PropConverters.PropertyConverter<?>> {
        public boolean putSimpleProperty(String propName, Object value) {
            return this.add(new PropConverters.SimplePropertyConverter(propName, value));
        }

        public <V> boolean putSimplePropList(String propName, List<V> list) {
            return this.add(new PropConverters.SimpleListPropertyConverter<V>(propName, list));
        }

        public Map<String, String> asMap() {
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            for (PropConverters.PropertyConverter conv : this) {
                propertiesMap.put(conv.getName(), conv.convert());
            }
            return propertiesMap;
        }
    }
}

