/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.env;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public final class JvmProcessIdInfo {
    public static long TESTS_FAKE_PID = 12345L;
    private long pid = 0L;

    public static long get() {
        if (Boolean.getBoolean("sl.tests.fakePid")) {
            return TESTS_FAKE_PID;
        }
        return SingletonHolder.getInstance().pid;
    }

    private JvmProcessIdInfo() {
        this.resolveProcessId();
    }

    private void resolveProcessId() {
        if (Boolean.getBoolean("sl.tests.fakePid")) {
            this.pid = TESTS_FAKE_PID;
            return;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String jvmName = runtimeMXBean.getName();
        this.pid = Long.valueOf(jvmName.split("@")[0]);
    }

    private static class SingletonHolder {
        static final JvmProcessIdInfo INSTANCE = new JvmProcessIdInfo();

        private SingletonHolder() {
        }

        static JvmProcessIdInfo getInstance() {
            return INSTANCE;
        }
    }
}

