/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.filters;

import java.util.regex.Pattern;

public class WildcardPattern {
    private String initialExpression;
    private Pattern compiledPattern;

    public WildcardPattern(String initialExpression) {
        this.initialExpression = initialExpression;
    }

    private Pattern createCompiledPattern() {
        if (this.initialExpression == null) {
            this.initialExpression = "";
        }
        String[] expressions = this.initialExpression.split("\\,");
        StringBuilder finalRegex = new StringBuilder(this.initialExpression.length() * 2);
        for (int i = 0; i < expressions.length; ++i) {
            String currentExpression = expressions[i];
            currentExpression = currentExpression.trim();
            if (i > 0) {
                finalRegex.append('|');
            }
            String encodedExpression = WildcardPattern.encodeExperssion(currentExpression);
            finalRegex.append('(').append(encodedExpression).append(')');
        }
        Pattern p = Pattern.compile(finalRegex.toString());
        return p;
    }

    public boolean matches(String valueToMatch) {
        if (this.compiledPattern == null) {
            this.compiledPattern = this.createCompiledPattern();
        }
        return this.compiledPattern.matcher(valueToMatch).matches();
    }

    private static String encodeExperssion(String expression) {
        StringBuilder encodedExpression = new StringBuilder(expression.length() * 2);
        block4: for (int i = 0; i < expression.length(); ++i) {
            char currentChar = expression.charAt(i);
            switch (currentChar) {
                case '*': {
                    encodedExpression.append(".*");
                    continue block4;
                }
                case '?': {
                    encodedExpression.append(".");
                    continue block4;
                }
                default: {
                    encodedExpression.append(Pattern.quote(String.valueOf(currentChar)));
                }
            }
        }
        return encodedExpression.toString();
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }
}

