/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.TextFileUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;

public class HttpRequestLogger {
    public static final String SEALIGHTS_CO = "sealights.co";
    public static final String REQUEST = "request-";
    private static final String URL_SEPARATOR = "/";
    private static final String URL_SEPARATOR_REPLACEMENT = "+";
    private static final String TIMESTAMP_FORMAT = "yyyy.MM.dd#HH.mm.ss.SSS";
    private static String logsLocation;

    public static String logHttpRequest(String method, String url, String body) {
        if (StringUtils.isNotEmpty(HttpRequestLogger.getLogsLocation())) {
            return new HttpRequestLogCommand(method, url, body, logsLocation).execute();
        }
        return null;
    }

    public static void initForTestsOnly() {
        logsLocation = null;
    }

    private static String getLogsLocation() {
        if (logsLocation == null) {
            logsLocation = SLHttpConfiguration.getRequestLogsLocation();
        }
        return logsLocation;
    }

    public static class HttpRequestLogCommand {
        private String method;
        private String url;
        private String body;
        private String logsLocation;

        public String execute() {
            String fileFolder = this.buildFilePath();
            String fileName = this.buildFileName();
            FileAndFolderUtils.verifyFolderExists(fileFolder);
            String filePathName = PathUtils.join(fileFolder, fileName);
            System.out.println("going to create " + filePathName);
            try {
                TextFileUtils.writeToFile(filePathName, this.body);
                return filePathName;
            }
            catch (Exception e) {
                return null;
            }
        }

        private String buildFilePath() {
            int sealightsIndex = this.url.indexOf(HttpRequestLogger.SEALIGHTS_CO);
            sealightsIndex = sealightsIndex == -1 ? 0 : (sealightsIndex += HttpRequestLogger.SEALIGHTS_CO.length() + 1);
            int lastIndex = this.url.lastIndexOf(HttpRequestLogger.URL_SEPARATOR);
            if (lastIndex == -1 || lastIndex < this.url.length() - 1) {
                lastIndex = this.url.length();
            }
            String urlToPath = this.url.substring(sealightsIndex, lastIndex).replace(HttpRequestLogger.URL_SEPARATOR, HttpRequestLogger.URL_SEPARATOR_REPLACEMENT);
            return PathUtils.join(this.logsLocation, urlToPath);
        }

        private String buildFileName() {
            String timestamp = new SimpleDateFormat(HttpRequestLogger.TIMESTAMP_FORMAT).format(new Date());
            return String.format("%s-%s%s.json", this.method, HttpRequestLogger.REQUEST, timestamp);
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public String getLogsLocation() {
            return this.logsLocation;
        }

        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setBody(String body) {
            this.body = body;
        }

        @Generated
        public void setLogsLocation(String logsLocation) {
            this.logsLocation = logsLocation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpRequestLogCommand)) {
                return false;
            }
            HttpRequestLogCommand other = (HttpRequestLogCommand)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$logsLocation = this.getLogsLocation();
            String other$logsLocation = other.getLogsLocation();
            return !(this$logsLocation == null ? other$logsLocation != null : !this$logsLocation.equals(other$logsLocation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpRequestLogCommand;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            String $logsLocation = this.getLogsLocation();
            result = result * 59 + ($logsLocation == null ? 43 : $logsLocation.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpRequestLogger.HttpRequestLogCommand(method=" + this.getMethod() + ", url=" + this.getUrl() + ", body=" + this.getBody() + ", logsLocation=" + this.getLogsLocation() + ")";
        }

        @Generated
        public HttpRequestLogCommand(String method, String url, String body, String logsLocation) {
            this.method = method;
            this.url = url;
            this.body = body;
            this.logsLocation = logsLocation;
        }
    }
}

