/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;

public class ProxyInfo {
    private static Logger LOG = LogFactory.getLogger(ProxyInfo.class);
    public static final ProxyInfo NO_PROXY = new ProxyInfo(null);
    public static final int DEFAULT_PORT = 80;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private static final String SEMI_COL = ":";
    private static final String AT_SIGN = "@";
    private static final String DOUBLE_SLASH = "//";
    private static final String SLASH = "/";
    private String host = "";
    private int port = 80;
    private String user = "";
    private String password = "";
    private String protocol = "http";

    public ProxyInfo(String proxyConfigValue) {
        if (StringUtils.isNotEmpty(proxyConfigValue)) {
            this.parseProxyConfig(this.trimProtocol(proxyConfigValue));
            if (this.isEmpty()) {
                throw new RuntimeException(String.format("Invalid proxy configuration: '%s'", proxyConfigValue));
            }
        }
    }

    public boolean isEmpty() {
        return StringUtils.isNullOrEmpty(this.host);
    }

    public boolean isAuthorized() {
        return StringUtils.isNotEmpty(this.user) && StringUtils.isNotEmpty(this.password);
    }

    public String getUrlString() {
        return String.format("%s://%s:%s", this.protocol, this.host, this.port);
    }

    public URL getUrl() {
        try {
            return new URL(this.getUrlString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseProxyConfig(String rawValue) {
        String partBeforeSlash = rawValue.split(SLASH)[0];
        String[] splitsByAtSign = partBeforeSlash.split(AT_SIGN);
        switch (splitsByAtSign.length) {
            case 1: {
                this.parseHostAndPort(splitsByAtSign[0]);
                break;
            }
            case 2: {
                if (!this.parseCredentials(splitsByAtSign[0])) break;
                this.parseHostAndPort(splitsByAtSign[1]);
                break;
            }
        }
    }

    private void parseHostAndPort(String rawValue) {
        String[] splits = rawValue.split(SEMI_COL);
        switch (splits.length) {
            case 1: {
                this.host = splits[0];
                break;
            }
            case 2: {
                this.host = splits[0];
                this.tryAssignPort(splits[1]);
                break;
            }
        }
    }

    private boolean parseCredentials(String rawValue) {
        if (StringUtils.isNullOrEmpty(rawValue)) {
            LOG.error("Invalid proxy credentials: empty values");
            return false;
        }
        String[] splits = rawValue.split(SEMI_COL);
        if (2 == splits.length) {
            this.user = splits[0];
            this.password = splits[1];
            return true;
        }
        LOG.error("Invalid proxy credentials: credentials are not provided in format '{user}:{password}'");
        return false;
    }

    private String trimProtocol(String url) {
        if (!url.startsWith(HTTP)) {
            return url;
        }
        int hostIndex = url.indexOf(DOUBLE_SLASH);
        if (hostIndex != -1) {
            this.protocol = url.substring(0, hostIndex - 1);
            return url.substring(hostIndex + DOUBLE_SLASH.length());
        }
        return "";
    }

    private boolean tryAssignPort(String value) {
        try {
            this.port = Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "empty";
        }
        return this.isAuthorized() ? String.format("[user:%s, password:***, url:'%s']", this.user, this.getUrlString()) : String.format("url:'%s'", this.getUrlString());
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyInfo)) {
            return false;
        }
        ProxyInfo other = (ProxyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProxyInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        return result;
    }
}

