/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class ProxyServerUrl {
    private static volatile String proxyServerUrl = null;

    public static String get() {
        if (proxyServerUrl == null) {
            ProxyServerUrl.initValue();
        }
        return proxyServerUrl;
    }

    private static synchronized void initValue() {
        if (proxyServerUrl == null) {
            proxyServerUrl = new ProxyServerUrl().resolve();
        }
    }

    static void resetForTests() {
        proxyServerUrl = null;
    }

    public String resolve() {
        String host = SLHttpConfiguration.getProxyServerHost();
        if (StringUtils.isNullOrEmpty(host)) {
            return host;
        }
        Integer port = SLHttpConfiguration.getProxyServerPort();
        if (port != null) {
            host = String.format("%s:%s", host, port);
        }
        return this.validateHost(host);
    }

    private String validateHost(String host) {
        try {
            new URI(host);
            return host;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

