/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.client.SLApacheHttpClient;
import io.sealights.onpremise.agents.infra.http.custom.SLCustomHttpClient;

public final class SLHttpClientFactory {
    private static volatile SLApacheHttpClient httpApacheClient;

    public static synchronized SLHttpClient getDefaultHttpClient(String token, ProxyInfo proxyInfo) {
        SLHttpClient customHttpClient = SLHttpClientFactory.createCustomHttpClient(token, proxyInfo);
        if (customHttpClient != null) {
            return customHttpClient;
        }
        return SLHttpClientFactory.initSLApacheHttpClient(token, proxyInfo);
    }

    public static synchronized SLApacheHttpClient getSLApacheHttpClient(String token, ProxyInfo proxyInfo) {
        return SLHttpClientFactory.initSLApacheHttpClient(token, proxyInfo);
    }

    public static void resetForTestsOnly() {
        httpApacheClient = null;
    }

    private static SLHttpClient createCustomHttpClient(String token, ProxyInfo proxyInfo) {
        boolean useCustomClient = SLHttpConfiguration.isUseCustomClient();
        if (useCustomClient && (proxyInfo == null || !proxyInfo.isAuthorized())) {
            return new SLCustomHttpClient(token, proxyInfo);
        }
        return null;
    }

    private static SLApacheHttpClient initSLApacheHttpClient(String token, ProxyInfo proxyInfo) {
        if (httpApacheClient == null) {
            httpApacheClient = new SLApacheHttpClient(token, proxyInfo);
        }
        return httpApacheClient;
    }
}

