/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.api;

import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.ProxyServerUrl;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClientFactory;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class SLServiceProxy {
    private static Logger LOG = LogFactory.getLogger(SLServiceProxy.class);
    private String token;
    private String proxyConfig;
    private String server;
    private boolean compressRequests;
    private SLHttpClient httpClient;

    public SLServiceProxy(SLAgentConfiguration cfg) {
        this(cfg.getToken(), cfg.getServer(), cfg.getProxy());
    }

    public SLServiceProxy(String token, String server, String proxyConfig) {
        this(token, server, proxyConfig, false);
    }

    public SLServiceProxy(String token, String server, String proxyConfig, boolean compressRequests) {
        String proxyServerHost = ProxyServerUrl.get();
        if (StringUtils.isNotEmpty(proxyServerHost)) {
            LOG.info("[{}] : using proxy-server {} ", (Object)this.getTag(), (Object)proxyServerHost);
            this.server = proxyServerHost;
            this.token = null;
        } else {
            this.server = server;
            this.token = token;
        }
        this.proxyConfig = proxyConfig;
        this.compressRequests = compressRequests;
    }

    protected SLHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = SLHttpClientFactory.getDefaultHttpClient(this.token, this.getProxyInfo());
            this.httpClient.setCompressRequests(this.compressRequests);
        }
        return this.httpClient;
    }

    protected ProxyInfo getProxyInfo() {
        return new ProxyInfo(this.proxyConfig);
    }

    protected void logError(String errorMsg, Exception exception) {
        String logMsg = errorMsg + ", error:" + exception.toString();
        LOG.error(logMsg);
        this.logConsoleError(logMsg);
    }

    protected void logConsoleError(String errorMsg) {
        ConsoleLogger consoleLog = LogFactory.createConsoleLogger();
        consoleLog.error(errorMsg);
    }

    public abstract String getTag();

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public boolean isCompressRequests() {
        return this.compressRequests;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setProxyConfig(String proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setCompressRequests(boolean compressRequests) {
        this.compressRequests = compressRequests;
    }

    @Generated
    public void setHttpClient(SLHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SLServiceProxy)) {
            return false;
        }
        SLServiceProxy other = (SLServiceProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCompressRequests() != other.isCompressRequests()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$proxyConfig = this.getProxyConfig();
        String other$proxyConfig = other.getProxyConfig();
        if (this$proxyConfig == null ? other$proxyConfig != null : !this$proxyConfig.equals(other$proxyConfig)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        SLHttpClient this$httpClient = this.getHttpClient();
        SLHttpClient other$httpClient = other.getHttpClient();
        return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SLServiceProxy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCompressRequests() ? 79 : 97);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $proxyConfig = this.getProxyConfig();
        result = result * 59 + ($proxyConfig == null ? 43 : $proxyConfig.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        SLHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SLServiceProxy(token=" + this.getToken() + ", proxyConfig=" + this.getProxyConfig() + ", server=" + this.getServer() + ", compressRequests=" + this.isCompressRequests() + ", httpClient=" + this.getHttpClient() + ")";
    }
}

