/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.http.client.HttpClientLogging;
import io.sealights.onpremise.agents.infra.logging.DefaultLogManager;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogManager;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"UnitTest"})
public class HttpClientLoggingTest {
    @BeforeMethod
    public void setMethod() {
        this.clearProperty();
    }

    @AfterMethod
    public void tearDownMethod() {
        this.clearProperty();
    }

    @Test
    public void configureLogsDebug_propertyNotSet_shouldDoNothing() {
        LogManager logMgrSpy = this.prepareLogFactory();
        HttpClientLogging.configureLogsDebug();
        ((LogManager)Mockito.verify((Object)logMgrSpy, (VerificationMode)Mockito.never())).httpLogsDebugOn(Matchers.anyString());
    }

    @Test
    public void configureLogsDebug_propertySet_shouldSetDegugLevel() {
        System.setProperty("sl.httpDebugLog", "org.apache.http");
        LogManager logMgrSpy = this.prepareLogFactory();
        HttpClientLogging.configureLogsDebug();
        ((LogManager)Mockito.verify((Object)logMgrSpy)).httpLogsDebugOn(Matchers.anyString());
    }

    private LogManager prepareLogFactory() {
        LogManager logMgrSpy = (LogManager)Mockito.spy((Object)new DefaultLogManager());
        LogFactory.bindLogManager(logMgrSpy);
        return logMgrSpy;
    }

    private void clearProperty() {
        System.clearProperty("sl.httpDebugLog");
    }
}

