/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.http.api.HttpClientLogFormatter;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import lombok.Generated;

public class HttpExceptions {

    public static class SLHttp404NotFoundException
    extends SLHttpException {
        public SLHttp404NotFoundException(SLHttpResult<?> result) {
            super("Returned status code 404 (url not found)", result);
        }
    }

    public static class SLHttpException
    extends RuntimeException {
        private SLHttpResult<?> result;

        public SLHttpException(SLHttpResult<?> result) {
            this(String.format("Server response error: status code=%s and body=%s", result.getStatusCode(), HttpClientLogFormatter.bodyToLogString(result.getBody())), result);
        }

        public SLHttpException(String message, SLHttpResult<?> result) {
            this(message);
            this.result = result;
            if (result.getStatusMessage() == null) {
                result.setStatusMessage(message);
            }
        }

        public SLHttpException(String message, SLHttpResult<?> result, Throwable cause) {
            this(message, cause);
            this.result = result;
            if (result.getStatusMessage() == null) {
                result.setStatusMessage(message);
            }
        }

        public SLHttpException(String message) {
            super(message);
        }

        public SLHttpException(String message, Throwable reason) {
            super(message, reason);
        }

        @Generated
        public SLHttpResult<?> getResult() {
            return this.result;
        }

        @Generated
        public void setResult(SLHttpResult<?> result) {
            this.result = result;
        }
    }
}

