/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.http.api.AgentIdentificationDataHolder;
import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.client.AuthorizationMode;
import io.sealights.onpremise.agents.infra.http.utils.SSLCertificateHandler;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.net.URL;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

public class HttpRequestConfigurator {
    private static Logger LOG = LogFactory.getLogger(HttpRequestConfigurator.class);
    private String token;
    private boolean compressRequest;
    private ProxyInfo proxyInfo;
    private RequestConfig requestConfiguration;
    private boolean useProxyServer;

    public HttpRequestConfigurator(String token, boolean compressRequest, ProxyInfo proxyInfo) {
        this.token = token;
        this.compressRequest = compressRequest;
        this.proxyInfo = proxyInfo;
        this.useProxyServer = StringUtils.isNotEmpty(SLHttpConfiguration.getProxyServerHost());
    }

    public void configureRequest(HttpUriRequestBase httpRequest, AuthorizationMode authorizationMode) throws Exception {
        this.configureRequest(httpRequest, authorizationMode, null, false);
    }

    public void configureRequest(HttpUriRequestBase httpRequest, AuthorizationMode authorizationMode, String serviceTag, boolean ignoreError404) throws Exception {
        if (!this.useProxyServer && authorizationMode.equals((Object)AuthorizationMode.AUTHORIZED)) {
            httpRequest.setHeader("Authorization", (Object)("Bearer " + this.token));
        }
        if (this.useProxyServer) {
            this.setProxyServerHeaders(httpRequest, serviceTag, ignoreError404);
        }
        httpRequest.setHeader("sl-metadata", (Object)JsonObjectMapper.toJson(AgentIdentificationDataHolder.getAgentIdentificationData()));
        httpRequest.setConfig(this.requestConfiguration);
    }

    private void setProxyServerHeaders(HttpUriRequestBase httpRequest, String serviceTag, boolean ignoreError404) {
        if (serviceTag != null) {
            httpRequest.setHeader("sl-service-proxy-tag", (Object)serviceTag);
        }
        httpRequest.setHeader("ignore-error-404", (Object)"true");
    }

    public ContentType resolveContentType(SLHttpRequest<?> request) {
        switch (request.getContentType()) {
            case APPLICATION_OCTET_STREAM: {
                return ContentType.APPLICATION_OCTET_STREAM;
            }
        }
        return ContentType.APPLICATION_JSON;
    }

    protected HttpClientBuilder withProxy(HttpClientBuilder httpClientBuilder, RequestConfig.Builder requestConfigBuilder) {
        URL proxyUrl = this.proxyInfo.getUrl();
        HttpHost proxyHost = new HttpHost(proxyUrl.getProtocol(), proxyUrl.getHost(), proxyUrl.getPort());
        requestConfigBuilder.setProxy(proxyHost);
        if (this.proxyInfo.isAuthorized()) {
            httpClientBuilder = this.withCredentials(httpClientBuilder);
            requestConfigBuilder.setProxyPreferredAuthSchemes(Arrays.asList("Basic"));
        }
        LOG.info("using proxy:'{}'", (Object)this.proxyInfo);
        return httpClientBuilder;
    }

    protected HttpClientBuilder withCredentials(HttpClientBuilder httpClientBuilder) {
        CredentialsProvider credsProvider = this.createCredentialsProvider();
        httpClientBuilder.setDefaultCredentialsProvider(credsProvider);
        return httpClientBuilder;
    }

    protected CredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.proxyInfo.getHost(), this.proxyInfo.getPort()), (Credentials)new UsernamePasswordCredentials(this.proxyInfo.getUser(), this.proxyInfo.getPassword().toCharArray()));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost proxyHost = new HttpHost(this.proxyInfo.getProtocol(), this.proxyInfo.getHost(), this.proxyInfo.getPort());
        authCache.put(proxyHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        return credsProvider;
    }

    public HttpClientBuilder initRequestConfiguration(HttpClientBuilder httpClientBuilder) {
        httpClientBuilder = this.configureSSL(httpClientBuilder);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setContentCompressionEnabled(this.compressRequest).setConnectTimeout(Timeout.ofMilliseconds((long)SLHttpConfiguration.getConnectionTimeoutMsec())).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)SLHttpConfiguration.getReadTimeoutMsec()));
        if (this.proxyInfo != null && !this.proxyInfo.isEmpty()) {
            httpClientBuilder = this.withProxy(httpClientBuilder, requestConfigBuilder);
        }
        this.requestConfiguration = requestConfigBuilder.build();
        httpClientBuilder.setDefaultRequestConfig(this.requestConfiguration);
        return httpClientBuilder;
    }

    protected HttpClientBuilder configureSSL(HttpClientBuilder httpClientBuilder) {
        SSLContext sslContext = SSLCertificateHandler.createCustomSSLContext();
        if (sslContext != null && SSLCertificateHandler.shouldIgnoreCertificateErrors()) {
            SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        return httpClientBuilder;
    }
}

