/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.AuthorizationMode;
import io.sealights.onpremise.agents.infra.http.client.ExceptionMatchers;
import io.sealights.onpremise.agents.infra.http.client.FileDownloadReader;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.http.client.HttpRequestConfigurator;
import io.sealights.onpremise.agents.infra.http.client.SecurityProvidersOrganizer;
import io.sealights.onpremise.agents.infra.http.utils.FileDownloadExecutor;
import io.sealights.onpremise.agents.infra.http.utils.HttpRequestResponseMapper;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;

public class SLApacheHttpClient
extends SLHttpClient {
    private static Logger LOG = LogFactory.getLogger(SLApacheHttpClient.class);
    private CloseableHttpClient httpClient;
    private SecurityProvidersOrganizer securityProvidersOrganizer = new SecurityProvidersOrganizer();
    private HttpRequestConfigurator requestConfigurator;

    public SLApacheHttpClient(String token, ProxyInfo proxyInfo) {
        super(token, proxyInfo);
        this.requestConfigurator = new HttpRequestConfigurator(token, this.isCompressRequests(), proxyInfo);
        this.initInternalHttpClient();
    }

    @Override
    public void initConnection(SLHttpRequest.RequestContentType contentType) {
    }

    @Override
    public <T> SLHttpResult<T> sendPostRequest(SLHttpRequest<T> request) {
        HttpPost httpPost = new HttpPost(request.getUrl());
        String body = this.fillHttpRequestBody(request, (HttpUriRequestBase)httpPost);
        return this.sendHttpRequest(request, (HttpUriRequestBase)httpPost, body);
    }

    @Override
    public <T> SLHttpResult<T> sendPutRequest(SLHttpRequest<T> request) {
        HttpPut httpPut = new HttpPut(request.getUrl());
        String body = this.fillHttpRequestBody(request, (HttpUriRequestBase)httpPut);
        return this.sendHttpRequest(request, (HttpUriRequestBase)httpPut, body);
    }

    private <T> String fillHttpRequestBody(SLHttpRequest<T> request, HttpUriRequestBase httpRequest) {
        String body;
        Object requestData = request.getRequestData();
        if (requestData instanceof HttpEntity) {
            HttpEntity httpEntity = (HttpEntity)requestData;
            httpRequest.setEntity(httpEntity);
            body = requestData.getClass().getName();
        } else {
            body = JsonObjectMapper.toJson(requestData);
            StringEntity stringEntity = new StringEntity(body, this.requestConfigurator.resolveContentType(request));
            httpRequest.setEntity((HttpEntity)stringEntity);
        }
        return body;
    }

    @Override
    public <T> SLHttpResult<T> sendGetRequest(SLHttpRequest<T> request) {
        HttpGet httpGet = new HttpGet(request.getUrl());
        return this.sendHttpRequest(request, (HttpUriRequestBase)httpGet, null);
    }

    @Override
    public <T> SLHttpResult<T> sendDeleteRequest(SLHttpRequest<T> request) {
        if (request.getRequestData() == null) {
            HttpDelete httpDelete = new HttpDelete(request.getUrl());
            return this.sendHttpRequest(request, (HttpUriRequestBase)httpDelete, null);
        }
        HttpDelete httpDelete = new HttpDelete(request.getUrl());
        String body = this.fillHttpRequestBody(request, (HttpUriRequestBase)httpDelete);
        return this.sendHttpRequest(request, (HttpUriRequestBase)httpDelete, body);
    }

    @Override
    public SLHttpResult.SLHttpResultVoid downloadFileRequest(String serviceTag, String fromUrl, String toFileName) {
        FileDownloadReader reader = new FileDownloadReader(this.httpClient, this.requestConfigurator, this.securityProvidersOrganizer);
        return FileDownloadExecutor.execute(fromUrl, toFileName, null, reader);
    }

    @Override
    public boolean isFatalError(Throwable e) {
        return super.isFatalError(e) || e instanceof ClientProtocolException;
    }

    protected <T> SLHttpResult<T> sendHttpRequest(SLHttpRequest<T> slRequest, HttpUriRequestBase httpRequest, String nullableBody) {
        return this.sendHttpRequest(slRequest, httpRequest, AuthorizationMode.AUTHORIZED, nullableBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> SLHttpResult<T> sendHttpRequest(SLHttpRequest<T> slRequest, HttpUriRequestBase httpRequest, AuthorizationMode authorized, String nullableBody) {
        this.logRequestStart(slRequest.getServiceTag(), httpRequest.getMethod(), slRequest.getUrl(), nullableBody);
        SLHttpResult slResult = new SLHttpResult();
        CloseableHttpResponse response = null;
        try {
            this.requestConfigurator.configureRequest(httpRequest, authorized, slRequest.getServiceTag(), slRequest.isIgnoreError404());
            response = this.httpClient.execute((ClassicHttpRequest)httpRequest);
            this.fillResult(slRequest, httpRequest.getMethod(), response, slResult, slRequest.getResponseClass());
            SLHttpResult sLHttpResult = slResult;
            return sLHttpResult;
        }
        catch (ClientProtocolException protocolException) {
            throw this.handleClientProtocolException(httpRequest, slResult, protocolException);
        }
        catch (HttpExceptions.SLHttp404NotFoundException e) {
            slResult.setStatusCode(404);
            throw e;
        }
        catch (Throwable e) {
            if (ExceptionMatchers.isBouncyCastleProviderException(e)) {
                this.securityProvidersOrganizer.moveSunECProviderOnTop();
                SLHttpResult<T> sLHttpResult = this.sendHttpRequest(slRequest, httpRequest, nullableBody);
                return sLHttpResult;
            }
            if (ExceptionMatchers.isSslBrokenPipeException(e)) {
                this.restartInternalClient();
                SLHttpResult<T> sLHttpResult = this.sendHttpRequest(slRequest, httpRequest, nullableBody);
                return sLHttpResult;
            }
            SLHttpResult sLHttpResult = this.handleErrorResponse(httpRequest, slResult, e);
            return sLHttpResult;
        }
        finally {
            this.logRequestEnd(slRequest.getServiceTag(), httpRequest.getMethod(), slRequest.getUrl(), slResult, slRequest.isIgnoreError404());
            this.closeResponse(response);
            this.securityProvidersOrganizer.restoreOriginalOrder();
        }
    }

    private HttpExceptions.SLHttpException handleClientProtocolException(HttpUriRequestBase httpRequest, SLHttpResult slResult, ClientProtocolException protocolException) {
        String originalMessage = protocolException.getCause().getMessage();
        if (originalMessage != null) {
            LOG.error("Exception message is: " + originalMessage);
            LOG.error("Exception message in bytes is: " + Arrays.toString(originalMessage.getBytes(StandardCharsets.UTF_8)));
        }
        return new HttpExceptions.SLHttpException("Exception during call " + httpRequest.getMethod() + " " + httpRequest.getPath(), slResult, protocolException);
    }

    protected <T> SLHttpResult<T> fillResult(SLHttpRequest<T> request, String method, CloseableHttpResponse response, SLHttpResult<T> slResult, Class<T> responseClass) throws IOException, UnsupportedOperationException {
        slResult.setStatusCode(response.getCode());
        HttpEntity responseHttpEntity = response.getEntity();
        if (responseHttpEntity != null) {
            InputStream contentStream = null;
            try {
                contentStream = responseHttpEntity.getContent();
            }
            catch (UnsupportedOperationException ue) {
                LOG.error("Exception in reading response content", (Throwable)ue);
            }
            HttpRequestResponseMapper.setResponseBody(slResult, contentStream);
        }
        this.logRequestEnd(request.getServiceTag(), method, request.getUrl(), slResult, request.isIgnoreError404());
        this.handleResponse(slResult, responseClass);
        return slResult;
    }

    protected void initInternalHttpClient() {
        if (this.httpClient != null) {
            return;
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties();
        httpClientBuilder = this.requestConfigurator.initRequestConfiguration(httpClientBuilder);
        this.httpClient = httpClientBuilder.build();
    }

    protected void restartInternalClient() {
        this.closeClient();
        this.initInternalHttpClient();
    }

    protected void closeResponse(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void closeClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.httpClient = null;
        }
    }

    protected <T> SLHttpResult<T> handleErrorResponse(HttpUriRequestBase httpRequest, SLHttpResult<T> slResult, Throwable e) {
        String msg = String.format("Failed to send '%s' request to '%s'. Error: %s", httpRequest.getMethod(), httpRequest.getRequestUri(), e.toString());
        if (!(e instanceof HttpExceptions.SLHttpException)) {
            LOG.error(msg, e);
        }
        throw new HttpExceptions.SLHttpException(msg, slResult, e);
    }

    @Override
    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), super.toString());
    }

    @Generated
    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

