/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.http.api.AgentIdentificationDataHolder;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.client.AuthorizationMode;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.http.client.SLApacheHttpClient;
import io.sealights.onpremise.agents.infra.http.client.SLHttpClientMockUtils;
import io.sealights.onpremise.agents.infra.http.client.SLHttpClientTestBase;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SLApacheHttpClientTest
extends SLHttpClientTestBase {
    private static final String TOKEN = "token";

    @Test
    public void createInstanceWithTokenAndNullProxy_instanceIsCreated() {
        SLApacheHttpClient realClient = new SLApacheHttpClient("eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL0RFVi1OYWRhdi5hdXRoLnNlYWxpZ2h0cy5pby8iLCJqd3RpZCI6IkRFVi1OYWRhdixpLTI0OWY0ZWU0LEFQSUdXLWNhOWYyOWI4LWZkNDctNDAzMi04M2UzLTUxYzQ4YjEzNTgyOSwxNDc5OTE5MjMxMjMyIiwic3ViamVjdCI6IlNlYUxpZ2h0c0BhZ2VudCIsImF1ZGllbmNlIjpbImFnZW50cyJdLCJ4LXNsLXJvbGUiOiJhZ2VudCIsIngtc2wtc2VydmVyIjoiaHR0cHM6Ly9ERVYtTmFkYXYtZ3cuc2VhbGlnaHRzLmNvL2FwaSIsInNsX2ltcGVyX3N1YmplY3QiOiIiLCJpYXQiOjE0Nzk5MTkyMzF9.B2P3hLb7m0N0iB73j2SRWq5neGztEQWdV5InwaFJMRt5UF5sGHfc4ICrWz_2lb9sOYlNsU5LMygl1ubs51prfKS5nwCJ94iHahy4rYFxFkjXCYz1GOXawqwT-_pCS-_pwI6f9LFpVIHipxu3JOyY91dv_UDGU_eVIrCAaPBuJsZyrzNvvq2GoDW1-zh_KnV8MdhBPMStpgqvlAOiqy_UXlxdUVQI-iRJasm3tFkADzr3XUfE_GWlTRo8vAaZ8QWI_WNc6LLU0XLkvl9YCE7-hXGSLKLmugWi8VIHIn5YJPFKoXzOz2_Q54uAg5MOaZWjsDZl3Ab66pkggZkrRikISw7hWksCTOMY7VxB96kdsrJZiHlC4ifI68SfN0RkgokVnEw8FYzVnnwzBI9-TypFJE-rvmn3HFvaUp77CRohrPrNy7HmRg45dqxvGgwuaDce5aCMQa_KiVSIeBxA95siuENjltcd3LYbK_UWTvLRK7yJF-RC-ub1V2EFzRnXbn6MUTR8uTUZKuk2FebDE88_FJ-GQIafLqYgBi6fRenvobeNacTVG3_H9msU_cVlGDwYBVR_Jg_E5u0uU8ppfccUj7zipUth0K9f4I_mDdYCo9FfYpFmU4jAtmQVMFVXzXSovbYQAgFq6MlI1aixynhfU61B0PzYD_Tgs47nnJdWL6s", null);
        Assert.assertNotNull((Object)realClient);
    }

    @Test
    public void sendRetryRequest_sendHttpRequestIsCalled() {
        SLApacheHttpClient httpClient = (SLApacheHttpClient)Mockito.spy((Object)new SLApacheHttpClient(TOKEN, null));
        httpClient.setHttpClient(SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(200));
        httpClient.sendPostRetry(this.createFakeDataRequest());
        ((SLApacheHttpClient)Mockito.verify((Object)httpClient)).sendHttpRequest((SLHttpRequest)Matchers.any(), (HttpUriRequestBase)Matchers.any(HttpUriRequestBase.class), (AuthorizationMode)((Object)Matchers.any(AuthorizationMode.class)), Matchers.anyString());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendPostRequest_httpCodeNotOk_throwsSLHttpException() {
        SLApacheHttpClient httpClient = this.createSLApacheHttpClient(SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(400));
        httpClient.sendPostRequest(this.createFakeDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendGetRequest_httpCodeNotOk_throwsSLHttpException() {
        SLApacheHttpClient httpClient = this.createSLApacheHttpClient(SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(400));
        httpClient.sendGetRequest(this.createFakeNoDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendDeleteRequest_httpCodeNotOk_throwsSLHttpException() {
        SLApacheHttpClient httpClient = this.createSLApacheHttpClient(SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(400));
        httpClient.sendDeleteRequest(this.createFakeNoDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendDeleteWithBodyRequest_httpCodeNotOk_throwsSLHttpException() {
        SLApacheHttpClient httpClient = this.createSLApacheHttpClient(SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(400));
        httpClient.sendDeleteRequest(this.createFakeDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttp404NotFoundException.class})
    public void sendRequest_httpClientThrows404Exception_exceptionPropagated() {
        SLApacheHttpClient httpClient = this.createSLApacheHttpClient(SLHttpClientMockUtils.mockCloseableHttpClientWithException(this.FAKE_SL_404_EXCEPTION));
        httpClient.sendGetRequest(this.createFakeNoDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendRequest_httpClientThrowsAnyException_throwsSLHttpException() {
        SLApacheHttpClient httpClient = this.createSLApacheHttpClient(SLHttpClientMockUtils.mockCloseableHttpClientWithException(this.FAKE_SL_EXCEPTION));
        httpClient.sendGetRequest(this.createFakeNoDataRequest());
    }

    @Test
    public void sendRequest_httpClientThrowsAnyException_responseNotHandled() {
        SLApacheHttpClient httpClient = (SLApacheHttpClient)Mockito.spy((Object)this.createSLApacheHttpClient(null));
        httpClient.setHttpClient(SLHttpClientMockUtils.mockCloseableHttpClientWithException(this.FAKE_SL_EXCEPTION));
        this.sendRequest_httpClientThrowsAnyException_responseNotHandled(httpClient);
    }

    @Test
    public void sendDelete_withBody_bodyHandled() {
        SLApacheHttpClient httpClient = (SLApacheHttpClient)Mockito.spy((Object)this.createSLApacheHttpClient(SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(200)));
        httpClient.sendDeleteRequest(this.createFakeDataRequest());
        ArgumentCaptor argCaptor = ArgumentCaptor.forClass(String.class);
        ((SLApacheHttpClient)Mockito.verify((Object)httpClient)).sendHttpRequest((SLHttpRequest)Matchers.any(), (HttpUriRequestBase)Matchers.any(HttpUriRequestBase.class), (String)argCaptor.capture());
        Assert.assertEquals((String)((String)argCaptor.getValue()), (String)JsonObjectMapper.toJson("Fake request data"));
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendRetryRequest_retryThrowsException_throwsSLHttpException() {
        this.createSLApacheHttpClient(null).sendRequestRetry(this.createFakeNoDataRequest(), this.mockRetriableRequestWithException());
    }

    @Test
    public void sendRetryRequest_retryThrowsException_maxRetriesDone() {
        this.sendRetryRequest_retryThrowsException_maxRetriesDone(this.createSLApacheHttpClient());
    }

    @Test
    public void sendRetryRequest_nonRecoverableError405_oneRetryDone() {
        this.sendRetryRequest_nonRecoverableErrorCode_oneRetryDone(this.createSLApacheHttpClient(), 405);
    }

    @Test
    public void sendRetryRequest_nonRecoverableError401_oneRetryDone() {
        this.sendRetryRequest_nonRecoverableErrorCode_oneRetryDone(this.createSLApacheHttpClient(), 401);
    }

    @Test
    public void sendRetryRequest_recoverableError400_maxRetriesDone() {
        this.sendRetryRequest_recoverableErrorCode_maxRetriesDone(this.createSLApacheHttpClient(), 400);
    }

    @Test
    public void sendRetryRequest_customNotRecoverableError_oneRetryDone() {
        this.sendRetryRequest_customNotRecoverableError_oneRetryDone(this.createSLApacheHttpClient());
    }

    @Test
    public void sendRetryRequest_outOfMemoryError_oneRetryDone() {
        this.sendRetryRequest_outOfMemoryError_oneRetryDone(this.createSLApacheHttpClient());
    }

    @Test
    public void sendRequest_bouncyCastleProviderException_requestIsResent() throws Exception {
        SLApacheHttpClient httpClient = this.createHttpClientSpyForBouncyCastle();
        try {
            httpClient.sendGetRequest(this.createFakeNoDataRequest());
        }
        catch (Exception e) {
            ((SLApacheHttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.times((int)2))).sendHttpRequest((SLHttpRequest)Matchers.any(), (HttpUriRequestBase)Matchers.any(HttpUriRequestBase.class), (AuthorizationMode)((Object)Matchers.any(AuthorizationMode.class)), Matchers.anyString());
        }
    }

    @Test
    public void downloadFileRequest_bouncyCastleProviderException_requestIsResent() throws Exception {
        SLApacheHttpClient httpClient = this.createHttpClientSpyForBouncyCastle();
        try {
            httpClient.downloadFileRequest("", "", "");
        }
        catch (Exception e) {
            ((SLApacheHttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.times((int)2))).downloadFileRequest(Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        }
    }

    @Test
    public void sendRequest_sslBrokenPipeException_requestIsResent() throws Exception {
        SLApacheHttpClient httpClient = this.createHttpClientForSslBrokenPipe();
        try {
            httpClient.sendGetRequest(this.createFakeNoDataRequest());
        }
        catch (Exception e) {
            ((SLApacheHttpClient)Mockito.verify((Object)httpClient)).restartInternalClient();
            ((SLApacheHttpClient)Mockito.verify((Object)httpClient, (VerificationMode)Mockito.times((int)2))).sendHttpRequest((SLHttpRequest)Matchers.any(), (HttpUriRequestBase)Matchers.any(HttpUriRequestBase.class), (AuthorizationMode)((Object)Matchers.any(AuthorizationMode.class)), Matchers.anyString());
        }
    }

    private SLApacheHttpClient createHttpClientSpyForBouncyCastle() {
        SLApacheHttpClient httpClient = (SLApacheHttpClient)Mockito.spy((Object)new SLApacheHttpClient(TOKEN, null));
        CloseableHttpClient internalHttpClientMock = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        CloseableHttpResponse httpResponse = SLHttpClientMockUtils.mockCloseableHttpResponse(200);
        RuntimeException exception = SLHttpClientMockUtils.mockBouncyCastleException();
        try {
            Mockito.when((Object)internalHttpClientMock.execute((ClassicHttpRequest)Matchers.any(HttpUriRequest.class))).thenThrow(new Throwable[]{exception}).thenReturn((Object)httpResponse);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        httpClient.setHttpClient(internalHttpClientMock);
        return httpClient;
    }

    private SLApacheHttpClient createHttpClientForSslBrokenPipe() {
        SLApacheHttpClient httpClient = (SLApacheHttpClient)Mockito.spy((Object)new SLApacheHttpClient(TOKEN, null));
        CloseableHttpClient internalHttpClientMock = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        CloseableHttpResponse httpResponse = SLHttpClientMockUtils.mockCloseableHttpResponse(200);
        RuntimeException exception = SLHttpClientMockUtils.mockSslBrokenPipeCause();
        try {
            Mockito.when((Object)internalHttpClientMock.execute((ClassicHttpRequest)Matchers.any(HttpUriRequest.class))).thenThrow(new Throwable[]{exception}).thenReturn((Object)httpResponse);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        httpClient.setHttpClient(internalHttpClientMock);
        return httpClient;
    }

    private SLApacheHttpClient createSLApacheHttpClient() {
        return this.createSLApacheHttpClient(null);
    }

    private SLApacheHttpClient createSLApacheHttpClient(CloseableHttpClient internalClient) {
        SLApacheHttpClient slClient = new SLApacheHttpClient(TOKEN, null);
        if (internalClient != null) {
            slClient.setHttpClient(internalClient);
        }
        return slClient;
    }

    @Test
    public void sendHttpRequest_slmetadataHeaderIsSetInRequestPassedToHttpClient() throws Exception {
        SLApacheHttpClient slApacheHttpClient = new SLApacheHttpClient(TOKEN, null);
        CloseableHttpClient httpClient = SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(200);
        slApacheHttpClient.setHttpClient(httpClient);
        HttpUriRequestBase httpUriRequestBase = SLApacheHttpClientTest.createFakeHttpRequestWithoutSlmetadataHeader();
        ArgumentCaptor argCaptor = ArgumentCaptor.forClass(HttpUriRequestBase.class);
        slApacheHttpClient.sendHttpRequest(this.createFakeDataRequest(), httpUriRequestBase, "Fake request data");
        ((CloseableHttpClient)Mockito.verify((Object)httpClient)).execute((ClassicHttpRequest)argCaptor.capture());
        String slmetadata = ((HttpUriRequestBase)argCaptor.getValue()).getHeader("sl-metadata").getValue();
        Assert.assertNotNull((Object)slmetadata);
    }

    @Test
    public void sendHttpRequest_slmetadataHeaderValueContainsDataFromAgentIdentificationDataHolder() throws Exception {
        String agentId = AgentId.getAgentId();
        String agentType = "AgentType";
        String agentVersion = "1.0.0";
        String bsId = "12345678";
        AgentIdentificationDataHolder.setAgentData(agentType, agentVersion, bsId);
        SLApacheHttpClient slApacheHttpClient = new SLApacheHttpClient(TOKEN, null);
        CloseableHttpClient httpClient = SLHttpClientMockUtils.mockClosebaleHttpClientWithResponse(200);
        slApacheHttpClient.setHttpClient(httpClient);
        HttpUriRequestBase httpUriRequestBase = SLApacheHttpClientTest.createFakeHttpRequestWithoutSlmetadataHeader();
        ArgumentCaptor argCaptor = ArgumentCaptor.forClass(HttpUriRequestBase.class);
        slApacheHttpClient.sendHttpRequest(this.createFakeDataRequest(), httpUriRequestBase, "Fake request data");
        ((CloseableHttpClient)Mockito.verify((Object)httpClient)).execute((ClassicHttpRequest)argCaptor.capture());
        String slmetadataHeader = ((HttpUriRequestBase)argCaptor.getValue()).getHeader("sl-metadata").getValue();
        String expectedHeaderValue = "{\"agentId\":\"" + agentId + "\",\"agentType\":\"AgentType\",\"agentVersion\":\"1.0.0\",\"buildSessionId\":\"12345678\",\"agentTechnology\":\"java\"}";
        Assert.assertEquals((String)expectedHeaderValue, (String)slmetadataHeader);
    }

    private static HttpUriRequestBase createFakeHttpRequestWithoutSlmetadataHeader() throws URISyntaxException {
        return new HttpUriRequestBase("POST", new URI("fake-url"));
    }
}

