/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClientFactory;
import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class SLHttpClientTestBase {
    protected static final String REQUEST_DATA = "Fake request data";
    protected static final String FAKE_URL = "fake-url";
    protected static final String TEST_TAG = "TEST";
    protected static final String FAKE_EXCEPTION_MSG = "Fake exception";
    protected HttpExceptions.SLHttpException FAKE_SL_EXCEPTION = new HttpExceptions.SLHttpException("Fake exception", new SLHttpResult());
    protected HttpExceptions.SLHttp404NotFoundException FAKE_SL_404_EXCEPTION = new HttpExceptions.SLHttp404NotFoundException(new SLHttpResult(404));

    @BeforeMethod
    public void configure() {
        SystemPropertiesHelper.setProperty("sl.httpMaxAttempts", 1);
        SystemPropertiesHelper.setProperty("sl.httpAttemptInterval", 1);
    }

    @AfterMethod
    public void clearProperties() {
        System.clearProperty("sl.httpMaxAttempts");
        System.clearProperty("sl.httpAttemptInterval");
        SLHttpClientFactory.resetForTestsOnly();
    }

    protected void sendRequest_httpClientThrowsAnyException_responseNotHandled(SLHttpClient httpClientSpy) {
        try {
            httpClientSpy.sendGetRequest(this.createFakeNoDataRequest());
        }
        catch (Exception e) {
            ((SLHttpClient)Mockito.verify((Object)httpClientSpy, (VerificationMode)Mockito.never())).handleResponse((SLHttpResult)Matchers.any(), (Class)Matchers.any());
        }
    }

    protected void sendRetryRequest_retryThrowsException_maxRetriesDone(SLHttpClient httpClient) {
        SLHttpClient.RequestRetry retriableRequest = (SLHttpClient.RequestRetry)Mockito.spy(this.mockRetriableRequestWithException());
        try {
            httpClient.sendRequestRetry(this.createFakeNoDataRequest(), retriableRequest);
        }
        catch (HttpExceptions.SLHttpException e) {
            ((SLHttpClient.RequestRetry)Mockito.verify((Object)retriableRequest, (VerificationMode)Mockito.times((int)SLHttpConfiguration.getMaxAttempts()))).execute((SLHttpRequest)Matchers.any());
        }
    }

    protected void sendRetryRequest_outOfMemoryError_oneRetryDone(SLHttpClient httpClient) {
        SLHttpClient.RequestRetry retriableRequest = (SLHttpClient.RequestRetry)Mockito.spy(this.mockRetriableRequestWithOutOfMemory());
        try {
            httpClient.sendRequestRetry(this.createFakeNoDataRequest(), retriableRequest);
        }
        catch (HttpExceptions.SLHttpException e) {
            ((SLHttpClient.RequestRetry)Mockito.verify((Object)retriableRequest)).execute((SLHttpRequest)Matchers.any());
        }
    }

    protected void sendRetryRequest_nonRecoverableErrorCode_oneRetryDone(SLHttpClient httpClient, int httpCode) {
        SLHttpClient.RequestRetry retriableRequest = (SLHttpClient.RequestRetry)Mockito.spy(this.mockRetriableRequestWithCode(httpCode));
        httpClient.sendRequestRetry(this.createFakeNoDataRequest(), retriableRequest);
        ((SLHttpClient.RequestRetry)Mockito.verify((Object)retriableRequest)).execute((SLHttpRequest)Matchers.any());
    }

    protected void sendRetryRequest_recoverableErrorCode_maxRetriesDone(SLHttpClient httpClient, int httpCode) {
        SLHttpClient.RequestRetry retriableRequest = (SLHttpClient.RequestRetry)Mockito.spy(this.mockRetriableRequestWithCode(httpCode));
        httpClient.sendRequestRetry(this.createFakeNoDataRequest(), retriableRequest);
        ((SLHttpClient.RequestRetry)Mockito.verify((Object)retriableRequest, (VerificationMode)Mockito.times((int)SLHttpConfiguration.getMaxAttempts()))).execute((SLHttpRequest)Matchers.any());
    }

    protected void sendRetryRequest_customNotRecoverableError_oneRetryDone(SLHttpClient httpClient) {
        SLHttpClient.RequestRetry retriableRequest = (SLHttpClient.RequestRetry)Mockito.spy(this.mockRetriableRequestWithNotRecoverableError());
        httpClient.sendRequestRetry(this.createFakeNoDataRequest(), retriableRequest);
        ((SLHttpClient.RequestRetry)Mockito.verify((Object)retriableRequest)).execute((SLHttpRequest)Matchers.any());
    }

    protected SLHttpRequest<String> createFakeDataRequest() {
        return new SLHttpRequest<String>(TEST_TAG, FAKE_URL, REQUEST_DATA, String.class);
    }

    protected SLHttpRequest<String> createFakeNoDataRequest() {
        return new SLHttpRequest<String>(TEST_TAG, FAKE_URL, null, String.class);
    }

    protected SLHttpClient.RequestRetry<String> mockRetriableRequestWithCode(final int statusCode) {
        SLHttpClient.RequestRetry<String> fakeRetriableRequest = new SLHttpClient.RequestRetry<String>(){

            @Override
            public SLHttpResult<String> execute(SLHttpRequest<String> request) {
                return new SLHttpResult<String>(statusCode);
            }
        };
        return fakeRetriableRequest;
    }

    protected SLHttpClient.RequestRetry<String> mockRetriableRequestWithException() {
        SLHttpClient.RequestRetry<String> fakeRetriableRequest = new SLHttpClient.RequestRetry<String>(){

            @Override
            public SLHttpResult<String> execute(SLHttpRequest<String> request) {
                throw SLHttpClientTestBase.this.FAKE_SL_EXCEPTION;
            }
        };
        return fakeRetriableRequest;
    }

    protected SLHttpClient.RequestRetry<String> mockRetriableRequestWithOutOfMemory() {
        SLHttpClient.RequestRetry<String> fakeRetriableRequest = new SLHttpClient.RequestRetry<String>(){

            @Override
            public SLHttpResult<String> execute(SLHttpRequest<String> request) {
                throw new OutOfMemoryError(SLHttpClientTestBase.FAKE_EXCEPTION_MSG);
            }
        };
        return fakeRetriableRequest;
    }

    protected SLHttpClient.RequestRetry<String> mockRetriableRequestWithNotRecoverableError() {
        SLHttpClient.RequestRetry<String> fakeRetriableRequest = new SLHttpClient.RequestRetry<String>(){

            @Override
            public SLHttpResult<String> execute(SLHttpRequest<String> request) {
                throw SLHttpClientTestBase.this.FAKE_SL_EXCEPTION;
            }

            @Override
            public boolean isRecoverableError(int httpCode) {
                return false;
            }
        };
        return fakeRetriableRequest;
    }
}

