/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.client;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;

public class SecurityProvidersOrganizer {
    private static Logger LOG = LogFactory.getLogger(SecurityProvidersOrganizer.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String SUN_EC_PROVIDER = "SunEC";
    private static final String PROVIDERS_REORDER_MESSAGE = "'SunEC' security provider was moved to location ";
    private static final String SUN_EC_PROVIDER_NOTFOUND_MESSAGE = "'SunEC' security provider was not found";
    private int sunECOrigLocation = -1;
    private Provider sunEC = null;

    public synchronized void moveSunECProviderOnTop() {
        this.logProviders("Existing security providers: ");
        int count = 1;
        for (Provider p : Security.getProviders()) {
            if (SUN_EC_PROVIDER.equals(p.getName())) {
                this.sunEC = p;
                this.sunECOrigLocation = count;
                break;
            }
            ++count;
        }
        if (this.sunEC != null) {
            this.moveSunECProvider(1);
        } else {
            this.logMessage(SUN_EC_PROVIDER_NOTFOUND_MESSAGE);
        }
    }

    public synchronized void restoreOriginalOrder() {
        if (this.sunECOrigLocation != -1) {
            this.moveSunECProvider(this.sunECOrigLocation);
            this.sunECOrigLocation = -1;
            this.sunEC = null;
        }
    }

    protected void moveSunECProvider(int toLocation) {
        Security.removeProvider(this.sunEC.getName());
        Security.insertProviderAt(this.sunEC, toLocation);
        this.logMessage(PROVIDERS_REORDER_MESSAGE + toLocation);
    }

    private void logProviders(String title) {
        StringBuilder builder = new StringBuilder(title);
        int count = 1;
        for (Provider p : Security.getProviders()) {
            builder.append(String.format("[%d]-'%s'; ", count++, p.getName()));
        }
        String providersToString = builder.toString();
        this.logMessage(providersToString);
    }

    private void logMessage(String msg) {
        CONSOLE_LOG.info(msg);
        LOG.info(msg);
    }
}

