/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.custom;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpCustomRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.http.client.SLHttpClientTestBase;
import io.sealights.onpremise.agents.infra.http.custom.CustomHttpConnection;
import io.sealights.onpremise.agents.infra.http.custom.SLCustomHttpClient;
import io.sealights.onpremise.agents.infra.http.custom.TestableSLCustomHttpClient;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class SLCustomHttpClientTest
extends SLHttpClientTestBase {
    private static final String TOKEN = "token";

    @Test
    public void sendPostRequest_initMethodIsCalled() {
        TestableSLCustomHttpClient httpClientMock = (TestableSLCustomHttpClient)Mockito.spy((Object)new TestableSLCustomHttpClient());
        httpClientMock.setHttpConnection(this.mockHttpConnectionWithResponse(this.mockOkHttpResponse()));
        httpClientMock.sendPostRequest(this.createFakeDataRequest());
        ((TestableSLCustomHttpClient)Mockito.verify((Object)httpClientMock)).initConnection((SLHttpRequest.RequestContentType)((Object)Matchers.any(SLHttpRequest.RequestContentType.class)));
    }

    @Test
    public void sendRetryRequest_initMethodIsCalled() {
        TestableSLCustomHttpClient httpClientMock = (TestableSLCustomHttpClient)Mockito.spy((Object)new TestableSLCustomHttpClient());
        httpClientMock.setHttpConnection(this.mockHttpConnectionWithResponse(this.mockOkHttpResponse()));
        httpClientMock.sendRequestRetry(this.createFakeNoDataRequest(), this.mockGoodRetriableRequest());
        ((TestableSLCustomHttpClient)Mockito.verify((Object)httpClientMock)).initConnection((SLHttpRequest.RequestContentType)((Object)Matchers.any(SLHttpRequest.RequestContentType.class)));
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendPostRequest_httpCodeNotOk_throwsSLHttpException() {
        SLCustomHttpClient httpClientMock = this.createSLCustomHttpClient();
        httpClientMock.setHttpConnection(this.mockHttpConnectionWithResponse(this.mockErrHttpResponse(400)));
        httpClientMock.sendPostRequest(this.createFakeDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendGetRequest_httpCodeNotOk_throwsSLHttpException() {
        SLCustomHttpClient httpClientMock = this.createSLCustomHttpClient();
        httpClientMock.setHttpConnection(this.mockHttpConnectionWithResponse(this.mockErrHttpResponse(400)));
        httpClientMock.sendGetRequest(this.createFakeNoDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttp404NotFoundException.class})
    public void sendRequest_httpClientThrows404Exception_exceptionPropagated() {
        SLCustomHttpClient httpClientMock = this.createSLCustomHttpClient();
        httpClientMock.setHttpConnection(this.mockHttpClonnectionWithException(this.FAKE_SL_404_EXCEPTION));
        httpClientMock.sendGetRequest(this.createFakeNoDataRequest());
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendRequest_httpClientThrowsAnyException_throwsSLHttpException() {
        SLCustomHttpClient httpClientMock = this.createSLCustomHttpClient();
        httpClientMock.setHttpConnection(this.mockHttpClonnectionWithException(this.FAKE_SL_EXCEPTION));
        httpClientMock.sendGetRequest(this.createFakeNoDataRequest());
    }

    @Test
    public void sendRequest_httpClientThrowsAnyException_responseNotHandled() throws Exception {
        SLCustomHttpClient httpClientMock = (SLCustomHttpClient)Mockito.spy((Object)this.createSLCustomHttpClient());
        httpClientMock.setHttpConnection(this.mockHttpClonnectionWithException(this.FAKE_SL_EXCEPTION));
        this.sendRequest_httpClientThrowsAnyException_responseNotHandled(httpClientMock);
    }

    @Test(expectedExceptions={HttpExceptions.SLHttpException.class})
    public void sendRetryRequest_retryThrowsException_throwsSLHttpException() {
        this.createSLCustomHttpClient().sendRequestRetry(this.createFakeNoDataRequest(), this.mockRetriableRequestWithException());
    }

    @Test
    public void sendRetryRequest_retryThrowsException_maxRetriesDone() {
        this.sendRetryRequest_retryThrowsException_maxRetriesDone(this.createSLCustomHttpClient());
    }

    @Test
    public void sendRetryRequest_nonRecoverableError405_oneRetryDone() {
        this.sendRetryRequest_nonRecoverableErrorCode_oneRetryDone(this.createSLCustomHttpClient(), 405);
    }

    @Test
    public void sendRetryRequest_nonRecoverableError401_oneRetryDone() {
        this.sendRetryRequest_nonRecoverableErrorCode_oneRetryDone(this.createSLCustomHttpClient(), 401);
    }

    @Test
    public void sendRetryRequest_recoverableError400_maxRetriesDone() {
        this.sendRetryRequest_recoverableErrorCode_maxRetriesDone(this.createSLCustomHttpClient(), 400);
    }

    @Test
    public void sendRetryRequest_customNotRecoverableError_oneRetryDone() {
        this.sendRetryRequest_customNotRecoverableError_oneRetryDone(this.createSLCustomHttpClient());
    }

    @Test
    public void sendRetryRequest_outOfMemoryError_oneRetryDone() {
        this.sendRetryRequest_outOfMemoryError_oneRetryDone(this.createSLCustomHttpClient());
    }

    private CustomHttpConnection mockHttpConnectionWithResponse(SLHttpResult<String> slResult) {
        CustomHttpConnection httpConnectionMock = (CustomHttpConnection)Mockito.mock(CustomHttpConnection.class);
        Mockito.when(httpConnectionMock.sendRequest((SLHttpCustomRequest)Matchers.any(SLHttpCustomRequest.class), (ProxyInfo)Matchers.any(ProxyInfo.class), (SLHttpResult)Matchers.any())).thenReturn(slResult);
        return httpConnectionMock;
    }

    private CustomHttpConnection mockHttpClonnectionWithException(Exception e) {
        CustomHttpConnection httpConnectionMock = (CustomHttpConnection)Mockito.mock(CustomHttpConnection.class);
        Mockito.when(httpConnectionMock.sendRequest((SLHttpCustomRequest)Matchers.any(SLHttpCustomRequest.class), (ProxyInfo)Matchers.any(ProxyInfo.class), (SLHttpResult)Matchers.any())).thenThrow(new Throwable[]{e});
        return httpConnectionMock;
    }

    private SLHttpResult<String> mockOkHttpResponse() {
        SLHttpResult<String> response = new SLHttpResult<String>();
        response.setStatusCode(200);
        response.setBody("{}");
        response.setResponseObject("");
        return response;
    }

    private SLHttpResult<String> mockErrHttpResponse(int httpCode) {
        SLHttpResult<String> response = new SLHttpResult<String>();
        response.setStatusCode(httpCode);
        return response;
    }

    private SLHttpClient.RequestRetry<String> mockGoodRetriableRequest() {
        SLHttpClient.RequestRetry<String> fakeRetriableRequest = new SLHttpClient.RequestRetry<String>(){

            @Override
            public SLHttpResult<String> execute(SLHttpRequest<String> request) {
                SLHttpResult<String> goodResult = new SLHttpResult<String>();
                goodResult.setResponseObject("");
                return goodResult;
            }
        };
        return fakeRetriableRequest;
    }

    private SLCustomHttpClient createSLCustomHttpClient() {
        return new SLCustomHttpClient(TOKEN, null);
    }
}

