/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.testapp;

import com.lowagie.text.pdf.OcspClientBouncyCastle;
import io.sealights.onpremise.agents.infra.http.testapp.TestProxy;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.java.agent.test.infra.LoggingSetup;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ApacheHttpClientTester {
    private static final String BSID = "f0ab18ca-7498-4908-8049-8daa15a8d495";
    private static final String TOKEN = "eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL0RFVi1hbGEyLmF1dGguc2VhbGlnaHRzLmlvLyIsImp3dGlkIjoiREVWLWFsYTIsaS0wMTg5MGMwMGUxZTg3ODQzOSxBUElHVy02OGQyMWQ1Zi04ZTgyLTQxNDEtODFjOC0zNzMyZWQ5YmJjM2QsMTYwMDY3MjEyOTIwNCIsInN1YmplY3QiOiJTZWFMaWdodHNAYWdlbnQiLCJhdWRpZW5jZSI6WyJhZ2VudHMiXSwieC1zbC1yb2xlIjoiYWdlbnQiLCJ4LXNsLXNlcnZlciI6Imh0dHBzOi8vZGV2LWFsYTItZ3cuZGV2LnNlYWxpZ2h0cy5jby9hcGkiLCJzbF9pbXBlcl9zdWJqZWN0IjoiIiwiaWF0IjoxNjAwNjcyMTI5fQ.HexwdPezf1UZWU9uDN-KWoRvCk2czFbwsoBsRNIxsmvGNALaKOMR7jy85zqYDqfpfClx0pa6Gs3zQJfO4yVauKDAQtFr9VbLLH8vr2PBVetyrEVZvB7MzaxSgCeUCWeBpf-0jAfBwITqDtDWPcn0supUoRWpC0EiANAJBkQE787oYvkFmxT80H0bG8ZX1SGYj1T2lX9t1S0fkwLYEA-FDT7vScy2BB7O0hpwNvRmceo2tBMsnqxttfQmjDiqI7uBYG-VZscgjxxrz1xedmyco6NpxBF-obInvEBHC-m0FiIFjnoyb1r1z4qLetQNL0HZX9IdkAzfPagU6M5J4miOAMp0lQG8unvxKrv2SB9l2sXmvYzvNgAIU_WKDlpD-cT3awV4dWcUm9CPDxdr6iOs-yX_NE4-UPq93srSEukrvxnmhyeRu0k1D-hH45rhztNCYxsFTH9Na-yToUyOd8xlVuMqHUVyCGMqzYQgvdg8MMzwIH46ejHwrw4wWGiFA64j8Xs6ldnLLWx04DfLuODJROvu1r1VMBEBJ1vDPtYSRs2yOQqTtnvANmu-Oe_20cztLjQj-P5SwiB6jjKAj3NXqEBNRQNVYUosFiicZGVcHFwNiDuBkChdxtZiFe6xeogf9sM5Dap5Fx0rnkIXdz8fTlfpH9d6CuBmreTJgjCCBTA";
    private static final String SERVER = "https://dev-ala2-gw.dev.sealights.co/api";
    private static final String FIDDLER_PROXY = "127.0.0.1:8888";

    private static X509Certificate getCertificate() throws Exception {
        TrustManager[] tms;
        System.out.println("javax.net.ssl.keyStoreType: '" + System.getProperty("javax.net.ssl.keyStoreType") + "'");
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] pwdArray = "changeit".toCharArray();
        ks.load(new FileInputStream("C:\\Program Files\\Java\\jdk1.8.0_231\\jre\\lib\\security\\cacerts"), pwdArray);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        trustManagerFactory.init(ks);
        for (TrustManager tm : tms = trustManagerFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            X509TrustManager manager = (X509TrustManager)tm;
            X509Certificate[] acceptedIssuers = manager.getAcceptedIssuers();
            System.out.println("Found TrustManager with authorities. Length: " + acceptedIssuers.length);
            int i = 0;
            if (i < acceptedIssuers.length) {
                X509Certificate issuer = acceptedIssuers[i];
                return issuer;
            }
            return null;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ApacheHttpClientTester.switchProviders();
        ApacheHttpClientTester.executeRequest(new TestProxy(TOKEN, SERVER));
    }

    private static void switchProviders() throws Exception {
        System.out.println("Before loading using");
        Provider bc = null;
        for (Provider p : Security.getProviders()) {
            System.out.println("[tester] ------> '" + p.getName() + "'");
        }
        X509Certificate cert = ApacheHttpClientTester.getCertificate();
        OcspClientBouncyCastle x = new OcspClientBouncyCastle(cert, cert, "");
        try {
            x.getEncoded();
        }
        catch (Exception e) {
            System.out.println("Failed to execute. Providers are:");
            Provider[] providerArray = Security.getProviders();
            int n = providerArray.length;
            for (int i = 0; i < n; ++i) {
                Provider p = providerArray[i];
                System.out.println("[tester] ------> '" + p.getName() + "'");
                if (!p.getName().equals("BC")) continue;
                bc = p;
                System.out.println("bc found");
            }
        }
        Security.removeProvider(bc.getName());
        Security.insertProviderAt(bc, 1);
        for (Provider p : Security.getProviders()) {
            System.out.println("[tester -2] ------> '" + p.getName() + "'");
        }
    }

    private static void runWithFiddler() {
        System.setProperty("sl.ignoreCertificateErrors", "true");
        ApacheHttpClientTester.executeRequest(new TestProxy(TOKEN, SERVER, FIDDLER_PROXY));
    }

    private static void executeRequest(TestProxy proxy) {
        TestProxy.BuildSessionData httpResponse = proxy.executeGetBsDataRequest(BSID);
        System.out.println("\nResponse details:");
        System.out.println("-------------------------------");
        System.out.println(httpResponse);
        System.out.println("-------------------------------");
    }

    static {
        LoggingSetup.logsOn();
        System.setProperty("sl.log.level", Level.DEBUG.getName());
    }
}

