/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.testapp;

import io.sealights.onpremise.agents.infra.http.api.HttpClientLogFormatter;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;
import lombok.Generated;

public class TestProxy
extends SLServiceProxy {
    public static final BuildSessionData EMPTY_DATA = new BuildSessionData();
    private static final String BUILDSESSIONS = "build-sessions";
    private static final String BUILDSESSION = "buildsession";
    private static final String LAB_IDS = "lab-ids";
    private static final String ACTIVE = "active";
    private static final String AGENT_ID = "agentId";

    public TestProxy(String token, String server) {
        super(token, server, null);
    }

    public TestProxy(String token, String server, String proxy) {
        super(token, server, proxy);
    }

    @Override
    public String getTag() {
        return "test-proxy";
    }

    public BuildSessionData executeRequest() {
        try {
            String url = new UrlBuilder().withHost(this.getServer()).withPath("v1", LAB_IDS, "labId", BUILDSESSIONS, ACTIVE).withQueryParam(AGENT_ID, AGENT_ID).build();
            SLHttpResult<BuildSessionData> result = this.getHttpClient().sendGetRequest(new SLHttpRequest<BuildSessionData>(this.getTag(), url, BuildSessionData.class));
            return result.getResponseObject();
        }
        catch (Exception e) {
            this.logError("test-proxy fake requests - ignore the error", e);
            return EMPTY_DATA;
        }
    }

    public BuildSessionData executeGetBsDataRequest(String bsid) {
        try {
            String url = new UrlBuilder().withHost(this.getServer()).withPath("v2", "agents", BUILDSESSION, bsid).build();
            this.logConsoleError(HttpClientLogFormatter.logRequestStartMsg(this.getTag(), "GET", url, this.getToken(), null));
            SLHttpResult<BuildSessionData> result = this.getHttpClient().sendGetRequest(new SLHttpRequest<BuildSessionData>(this.getTag(), url, BuildSessionData.class));
            return result.getResponseObject();
        }
        catch (Exception e) {
            this.logError("test-proxy fake requests - ignore the error", e);
            return EMPTY_DATA;
        }
    }

    public static class BuildSessionData {
        private String appName;
        private String branchName;
        private String buildName;
        private String buildSessionId;

        @Generated
        public BuildSessionData() {
        }

        @Generated
        public String getAppName() {
            return this.appName;
        }

        @Generated
        public String getBranchName() {
            return this.branchName;
        }

        @Generated
        public String getBuildName() {
            return this.buildName;
        }

        @Generated
        public String getBuildSessionId() {
            return this.buildSessionId;
        }

        @Generated
        public void setAppName(String appName) {
            this.appName = appName;
        }

        @Generated
        public void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Generated
        public void setBuildName(String buildName) {
            this.buildName = buildName;
        }

        @Generated
        public void setBuildSessionId(String buildSessionId) {
            this.buildSessionId = buildSessionId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildSessionData)) {
                return false;
            }
            BuildSessionData other = (BuildSessionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
                return false;
            }
            String this$branchName = this.getBranchName();
            String other$branchName = other.getBranchName();
            if (this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName)) {
                return false;
            }
            String this$buildName = this.getBuildName();
            String other$buildName = other.getBuildName();
            if (this$buildName == null ? other$buildName != null : !this$buildName.equals(other$buildName)) {
                return false;
            }
            String this$buildSessionId = this.getBuildSessionId();
            String other$buildSessionId = other.getBuildSessionId();
            return !(this$buildSessionId == null ? other$buildSessionId != null : !this$buildSessionId.equals(other$buildSessionId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BuildSessionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            String $branchName = this.getBranchName();
            result = result * 59 + ($branchName == null ? 43 : $branchName.hashCode());
            String $buildName = this.getBuildName();
            result = result * 59 + ($buildName == null ? 43 : $buildName.hashCode());
            String $buildSessionId = this.getBuildSessionId();
            result = result * 59 + ($buildSessionId == null ? 43 : $buildSessionId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestProxy.BuildSessionData(appName=" + this.getAppName() + ", branchName=" + this.getBranchName() + ", buildName=" + this.getBuildName() + ", buildSessionId=" + this.getBuildSessionId() + ")";
        }
    }
}

