/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.utils;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FileDownloadExecutor {
    private static Logger LOG = LogFactory.getLogger(FileDownloadExecutor.class);

    public static SLHttpResult.SLHttpResultVoid execute(String fromUrl, String toFileName, ProxyInfo proxyInfo, FileReader fileReader) {
        SLHttpResult.SLHttpResultVoid slResult = new SLHttpResult.SLHttpResultVoid();
        try {
            fileReader.readFile(fromUrl, proxyInfo);
            LOG.info("download done to input stream, start file creation ...");
            slResult.setStatusCode(fileReader.getStatusCode());
            InputStream inStream = fileReader.getInputSTream();
            if (slResult.isStatusCodeOk() && inStream != null) {
                File destinationFile = new File(toFileName);
                boolean copied = FileDownloadExecutor.copyToFile(inStream, destinationFile);
                IOUtils.closeQuietly((InputStream)inStream);
                if (!copied || !destinationFile.exists()) {
                    String errorMsg = FileDownloadExecutor.getErrorMsg(fromUrl);
                    LOG.error(errorMsg);
                    slResult.setStatusCode(-1);
                    slResult.setStatusMessage(errorMsg);
                } else {
                    LOG.info("Recommended agent was downloaded into '{}'", (Object)destinationFile.getAbsolutePath());
                }
            } else {
                slResult.setStatusMessage(FileDownloadExecutor.getErrorMsg(fromUrl));
                if (slResult.isStatusCodeOk()) {
                    slResult.setStatusCode(-1);
                }
            }
        }
        catch (Throwable e) {
            slResult.setStatusCode(-1);
            String errorMsg = String.format("%s. Error: %s", FileDownloadExecutor.getErrorMsg(fromUrl), e.getMessage());
            slResult.setStatusMessage(errorMsg);
            LOG.error(errorMsg);
        }
        return slResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyToFile(InputStream inStream, File destinationFile) {
        FileOutputStream outStream = null;
        boolean result = true;
        try {
            int bytesRead;
            outStream = new FileOutputStream(destinationFile.getAbsoluteFile());
            byte[] buffer = new byte[8192];
            while ((bytesRead = inStream.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
                if (!Thread.interrupted()) continue;
                LOG.info("File download was cancelled");
                result = false;
                break;
            }
        }
        catch (Throwable e) {
            try {
                LOG.error("Error while copying to downloaded file", e);
                result = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        IOUtils.closeQuietly((OutputStream)outStream);
        return result;
    }

    private static String getErrorMsg(String fromUrl) {
        String errorFormat = "Failed to download the recommended agent from url '%s'";
        return String.format("Failed to download the recommended agent from url '%s'", fromUrl);
    }

    public static interface FileReader {
        public static final int UKNOWN_ERROR = -1;

        public void readFile(String var1, ProxyInfo var2) throws Throwable;

        public int getStatusCode();

        public InputStream getInputSTream() throws Throwable;
    }
}

