/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.utils;

import io.sealights.onpremise.agents.infra.http.api.ProxyInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.utils.FileDownloadExecutor;
import io.sealights.onpremise.agents.infra.utils.threads.FastShutdownTimeoutTimer;
import io.sealights.onpremise.agents.infra.utils.threads.ThreadUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test
public class FileDownloadExecutorTest {
    private static final String FROM_URL = "http://fromUrl";
    private static final String DEST_FILE = "destFile.jar";
    private FileDownloadExecutor.FileReader readerMock;

    @AfterMethod
    public void deleteTempFile() {
        File tempFile = new File(DEST_FILE);
        if (tempFile.exists()) {
            tempFile.delete();
        }
    }

    @Test
    public void executeInSeparateThread_doneInTimeWithOkResult_returnsStatusOk() throws Throwable {
        SimulateScheduledFiledownload testTask = this.executeInOtherThread(500);
        ((SimulateScheduledFiledownload)Mockito.verify((Object)testTask)).run();
        Assert.assertTrue((boolean)testTask.slResult.isStatusCodeOk());
    }

    @Test
    public void executeInSeparateThread_timeoutWithOkResult_returnsStatusError() throws Throwable {
        SimulateScheduledFiledownload testTask = this.executeInOtherThread(50);
        ((SimulateScheduledFiledownload)Mockito.verify((Object)testTask)).run();
        Assert.assertTrue((testTask.slResult == null || !testTask.slResult.isStatusCodeOk() ? 1 : 0) != 0);
    }

    private SimulateScheduledFiledownload executeInOtherThread(int awaitMillis) {
        SimulateScheduledFiledownload testTask = (SimulateScheduledFiledownload)Mockito.spy((Object)new SimulateScheduledFiledownload());
        testTask.start();
        ThreadUtils.sleepMillis(awaitMillis);
        testTask.cancel();
        return testTask;
    }

    @Test
    public void execute_readerFailsWithErrorCode_returnsResultWithSameCode() throws Throwable {
        this.readerMock = this.mockFileReaderWithError(404);
        SLHttpResult.SLHttpResultVoid slResult = FileDownloadExecutor.execute(FROM_URL, DEST_FILE, null, this.readerMock);
        Assert.assertEquals((int)slResult.getStatusCode(), (int)404, (String)"Wrong status code was returned:");
    }

    @Test
    public void execute_readerFailsWithException_returnsFileDownloadFailedCode() throws Throwable {
        String fakeErrorMessage = "Fake exception";
        this.readerMock = this.mockFileReaderWithException(new NullPointerException(fakeErrorMessage));
        SLHttpResult.SLHttpResultVoid slResult = FileDownloadExecutor.execute(FROM_URL, DEST_FILE, null, this.readerMock);
        Assert.assertEquals((int)slResult.getStatusCode(), (int)-1, (String)"Wrong status code was returned:");
        Assert.assertNotNull((Object)slResult.getStatusMessage());
        Assert.assertTrue((boolean)slResult.getStatusMessage().contains(fakeErrorMessage));
        this.assertFileNotCreated();
    }

    @Test
    public void execute_readerReturnsOkButNullInputStream_returnsFileDownloadFailedCode() throws Throwable {
        this.readerMock = this.mockFileReaderWithOkResult(false);
        SLHttpResult.SLHttpResultVoid slResult = FileDownloadExecutor.execute(FROM_URL, DEST_FILE, null, this.readerMock);
        Assert.assertEquals((int)slResult.getStatusCode(), (int)-1, (String)"Wrong status code was returned:");
        this.assertFileNotCreated();
    }

    @Test
    public void execute_readerReturnsOkAndnputStream_createsFileAndReturnsOk() throws Throwable {
        this.readerMock = this.mockFileReaderWithOkResult(true);
        SLHttpResult.SLHttpResultVoid slResult = FileDownloadExecutor.execute(FROM_URL, DEST_FILE, null, this.readerMock);
        Assert.assertEquals((int)slResult.getStatusCode(), (int)200, (String)"Wrong status code was returned:");
        File destFile = this.createDestFileObject();
        Assert.assertTrue((boolean)destFile.exists(), (String)"Destination file was not created");
    }

    private void assertFileNotCreated() {
        File destFile = this.createDestFileObject();
        Assert.assertFalse((boolean)destFile.exists(), (String)"Destination file should not be created");
    }

    private FileDownloadExecutor.FileReader mockFileReaderWithError(int expectedStatusCode) throws Throwable {
        this.readerMock = this.createFileReaderMock();
        Mockito.when((Object)this.readerMock.getStatusCode()).thenReturn((Object)expectedStatusCode);
        return this.readerMock;
    }

    private FileDownloadExecutor.FileReader mockFileReaderWithException(Exception e) throws Throwable {
        this.readerMock = this.createFileReaderMock();
        ((FileDownloadExecutor.FileReader)Mockito.doThrow((Throwable)e).when((Object)this.readerMock)).readFile(Matchers.anyString(), (ProxyInfo)Matchers.any(ProxyInfo.class));
        return this.readerMock;
    }

    private FileDownloadExecutor.FileReader mockFileReaderWithOkResult(boolean withInputStream) throws Throwable {
        this.readerMock = this.createFileReaderMock();
        Mockito.when((Object)this.readerMock.getStatusCode()).thenReturn((Object)200);
        if (withInputStream) {
            Mockito.when((Object)this.readerMock.getInputSTream()).thenReturn((Object)new ByteArrayInputStream("fake string".getBytes()));
        }
        return this.readerMock;
    }

    private File createDestFileObject() {
        return new File(DEST_FILE);
    }

    private FileDownloadExecutor.FileReader createFileReaderMock() {
        return (FileDownloadExecutor.FileReader)Mockito.mock(FileDownloadExecutor.FileReader.class);
    }

    class SimulateScheduledFiledownload
    extends FastShutdownTimeoutTimer {
        SLHttpResult.SLHttpResultVoid slResult;
        static final int TASK_SLEEP_MSEC = 50;

        public SimulateScheduledFiledownload() {
            super(5, TimeUnit.MICROSECONDS);
        }

        @Override
        public String getName() {
            return "test";
        }

        @Override
        public void run() {
            try {
                FileDownloadExecutorTest.this.readerMock = FileDownloadExecutorTest.this.mockFileReaderWithOkResult(true);
                Thread.sleep(50L);
                this.slResult = FileDownloadExecutor.execute(FileDownloadExecutorTest.FROM_URL, FileDownloadExecutorTest.DEST_FILE, null, FileDownloadExecutorTest.this.readerMock);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

