/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.utils;

import io.sealights.onpremise.agents.infra.http.api.SLHttpCustomRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public final class HttpRequestResponseMapper {
    public static void putRequestBodyToStream(SLHttpCustomRequest request, OutputStream output) throws Exception {
        HttpRequestResponseMapper.putBodyStringToStream(request.getRequestBody(), request.isCompressRequestBody(), output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putBodyStringToStream(String bodyString, boolean compressBody, OutputStream output) throws Exception {
        if (bodyString == null) {
            bodyString = "";
        }
        byte[] requestBodyAsBytes = bodyString.getBytes(StandardCharsets.UTF_8);
        try (DataOutputStream dataOutputSteam = null;){
            dataOutputSteam = new DataOutputStream(output);
            if (compressBody) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                    gzos.write(requestBodyAsBytes);
                }
                byte[] gzippedBytes = baos.toByteArray();
                requestBodyAsBytes = gzippedBytes;
            }
            dataOutputSteam.write(requestBodyAsBytes);
        }
    }

    public static <T> void setResponseBody(SLHttpResult<T> response, InputStream stream) {
        if (null != stream) {
            response.setBody(HttpRequestResponseMapper.streamToString(stream));
        } else {
            response.setBody("");
        }
    }

    public static String streamToString(InputStream stream) {
        if (stream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String line;
            InputStreamReader streamReader = new InputStreamReader(stream);
            bufferedReader = new BufferedReader(streamReader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read from InputStream. Error:", e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

