/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.http.utils;

import io.sealights.onpremise.agents.infra.http.api.SLHttpConfiguration;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"UnitTest"})
public class SLHttpConfigurationTest {
    @Test
    public void getProperties_systemPropsNotSet_defaultValuesRetrurned() {
        Assert.assertEquals((int)SLHttpConfiguration.getConnectionTimeoutMsec(), (int)10000, (String)this.wrongPropertyValue("sl.connectionTimeoutMS"));
        Assert.assertEquals((int)SLHttpConfiguration.getReadTimeoutMsec(), (int)20000, (String)this.wrongPropertyValue("sl.readTimeoutMS"));
        Assert.assertEquals((int)SLHttpConfiguration.getMaxAttempts(), (int)5, (String)this.wrongPropertyValue("sl.httpMaxAttempts"));
        Assert.assertEquals((int)SLHttpConfiguration.getAttemptInterval(), (int)5000, (String)this.wrongPropertyValue("sl.httpAttemptInterval"));
        Assert.assertEquals((int)SLHttpConfiguration.getPrintableBodySize(), (int)1024, (String)this.wrongPropertyValue("sl.maxPrintBodySize"));
        Assert.assertNull((Object)SLHttpConfiguration.getHttpClientRootLog(), (String)this.wrongPropertyValue("sl.httpDebugLog"));
        Assert.assertFalse((boolean)SLHttpConfiguration.isUseCustomClient(), (String)this.wrongPropertyValue("sl.useCustomClient"));
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty(SLHttpConfiguration.getRequestLogsLocation()), (String)this.wrongPropertyValue("sl.httpRequestsLogLocation"));
    }

    private String wrongPropertyValue(String propName) {
        return String.format("Wrong value of '%s':", propName);
    }
}

