/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.jarutils;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ArchiveUtils {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipName, String destFolder) {
        if (StringUtils.isNullOrEmpty(zipName)) {
            throw new IllegalArgumentException("Unable to unzip because the zip file name is null or empty.");
        }
        if (StringUtils.isNullOrEmpty(destFolder)) {
            throw new IllegalArgumentException("Unable to unzip because the destination folder is null or empty.");
        }
        ZipInputStream zis = null;
        try {
            byte[] buffer = new byte[1024];
            FileAndFolderUtils.verifyFolderExists(destFolder);
            zis = new ZipInputStream(new FileInputStream(zipName));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String entryFileName = ze.getName();
                try {
                    int len;
                    String filePath = FileAndFolderUtils.join(destFolder, entryFileName);
                    File currentZippedFile = new File(filePath);
                    new File(currentZippedFile.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(currentZippedFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                catch (Exception e) {
                    ArchiveUtils.showWarnOnConsole(String.format("Failed to process the current zip entry '%s'. Error: ", entryFileName), e);
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (Exception e) {
            try {
                ArchiveUtils.showWarnOnConsole(String.format("Failed to unzip file '%s', destFolder '%s'. Error: ", zipName, destFolder), e);
            }
            catch (Throwable throwable) {
                ArchiveUtils.tryCloseStreamSafe(zis);
                throw throwable;
            }
            ArchiveUtils.tryCloseStreamSafe(zis);
        }
        ArchiveUtils.tryCloseStreamSafe(zis);
    }

    private static void tryCloseStreamSafe(ZipInputStream zis) {
        if (zis != null) {
            try {
                zis.close();
            }
            catch (Exception e) {
                ArchiveUtils.showWarnOnConsole("Failed closing the stream. Error:", e);
            }
        }
    }

    private static void showWarnOnConsole(String errorMsg, Exception exception) {
        CONSOLE_LOG.warn(errorMsg, exception);
    }
}

