/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import io.sealights.onpremise.agents.infra.json.StringFieldByNameModifier;
import io.sealights.onpremise.agents.infra.json.TokenFieldSerializer;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JsonObjectMapper {
    private static final String TO_JSON_CONVERT_FAILURE = "to convert to Json";
    private static final String FROM_JSON_CONVERT_FAILURE = "to convert from Json";
    private static final String FROM_JSON_FILE_CONVERT_FAILURE = "to convert from Json file";
    private static final String TO_JSON_NODE_CONVERT_FAILURE = "to convert to JsonNode";
    private static Logger LOG = LogFactory.getLogger(JsonObjectMapper.class);
    private static volatile ObjectMapper objectMapper = null;

    public static String toJson(Object object, boolean prettyPrint) {
        if (object == null) {
            return "null";
        }
        try {
            if (prettyPrint) {
                JsonObjectMapper.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            } else {
                JsonObjectMapper.getObjectMapper().disable(SerializationFeature.INDENT_OUTPUT);
            }
            return JsonObjectMapper.getObjectMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            throw JsonObjectMapper.runtimeException(e, TO_JSON_CONVERT_FAILURE);
        }
    }

    public static String toJson(Object target) {
        return JsonObjectMapper.toJson(target, false);
    }

    public static JsonNode toJsonNode(Object object) {
        if (object == null) {
            throw JsonObjectMapper.runtimeException("to convert to Json: object is 'null'");
        }
        try {
            return JsonObjectMapper.getObjectMapper().valueToTree(object);
        }
        catch (Exception e) {
            throw JsonObjectMapper.runtimeException(e, TO_JSON_NODE_CONVERT_FAILURE);
        }
    }

    public static <T> T toObject(String json, Class<T> targetType) {
        if (StringUtils.isNullOrEmpty(json)) {
            throw JsonObjectMapper.runtimeException("to convert from Json: json is empty");
        }
        try {
            return (T)JsonObjectMapper.getObjectMapper().readValue(json, targetType);
        }
        catch (Exception e) {
            throw JsonObjectMapper.runtimeException(e, FROM_JSON_CONVERT_FAILURE);
        }
    }

    public static <T1, T2> Map<T1, T2> toMapObject(String json) {
        if (StringUtils.isNullOrEmpty(json)) {
            throw JsonObjectMapper.runtimeException("to convert from Json: json is empty");
        }
        try {
            return (Map)JsonObjectMapper.getObjectMapper().readValue(json, new TypeReference<Map<T1, T2>>(){});
        }
        catch (Exception e) {
            throw JsonObjectMapper.runtimeException(e, FROM_JSON_CONVERT_FAILURE);
        }
    }

    public static <T> T toObject(File jsonFile, Class<T> targetType) {
        if (!jsonFile.exists()) {
            throw JsonObjectMapper.runtimeException("to convert from Json file: file not exists");
        }
        try {
            LOG.debug("Converting from file '{}' to '{}'", (Object)jsonFile.getName(), targetType);
            return (T)JsonObjectMapper.getObjectMapper().readValue(jsonFile, targetType);
        }
        catch (Exception e) {
            throw JsonObjectMapper.runtimeException(e, FROM_JSON_FILE_CONVERT_FAILURE);
        }
    }

    public static <T> T toCollection(String json, TypeReference<?> collectionType) {
        if (StringUtils.isNullOrEmpty(json)) {
            throw JsonObjectMapper.runtimeException("to convert from Json: json is empty");
        }
        try {
            return (T)JsonObjectMapper.getObjectMapper().reader().forType(collectionType).readValue(json);
        }
        catch (Exception e) {
            throw JsonObjectMapper.runtimeException(e, FROM_JSON_CONVERT_FAILURE, json);
        }
    }

    public static <T> List<T> toList(String json, TypeReference<List<T>> typeReference) {
        return (List)JsonObjectMapper.toCollection(json, typeReference);
    }

    private static RuntimeException runtimeException(String failure) {
        return new RuntimeException(String.format("Failed %s", failure));
    }

    private static RuntimeException runtimeException(Exception e, String failure) {
        return JsonObjectMapper.runtimeException(e, failure, null);
    }

    private static RuntimeException runtimeException(Exception e, String failure, String json) {
        if (json != null) {
            LOG.error("Failed {} json:'{}'", (Object)failure, (Object)json);
        }
        return new RuntimeException(String.format("Failed %s. Error: %s", failure, e.toString()), e);
    }

    private static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            JsonObjectMapper.initObjectMapper();
        }
        return objectMapper;
    }

    private static synchronized ObjectMapper initObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            JsonObjectMapper.registerDataMasking(objectMapper);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
            objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
            JsonObjectMapper.addTrimStringDeserializer();
        }
        return objectMapper;
    }

    private static void registerDataMasking(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        TokenFieldSerializer tokenFieldSerializer = new TokenFieldSerializer();
        module.setSerializerModifier((BeanSerializerModifier)new StringFieldByNameModifier(Arrays.asList("authKey", "token", "machineName"), tokenFieldSerializer));
        objectMapper.registerModule((Module)module);
    }

    private static void addTrimStringDeserializer() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, (JsonDeserializer)new TrimStringDeserializer());
        objectMapper.registerModule((Module)module);
    }

    public static class TrimStringDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return parser.hasCurrentToken() ? parser.getText().trim() : null;
        }
    }
}

