/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.logging;

import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.logback.markers.SlMarkers;
import io.sealights.onpremise.agents.infra.utils.SlMsgFormatter;
import io.sealights.onpremise.agents.infra.utils.SlStringBuilderWriter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ConsoleLogger
implements Logger {
    public static final String DEFAULT_COMPONENT_TAG = "Sealights";
    private static final String PREFIX_DEFAULT_FMT = "[%s] [%s]";
    private static String componentTag = "Sealights";
    private final Level level;
    private String context;
    private String prefix;
    private static final String agentId = AgentId.getAgentId();
    private final EnumMap<Level, PrintStream> levelPrintStreamMap = new EnumMap(Level.class);
    private static final EnumMap<Level, String> LEVEL_PREFIX_MAP = new EnumMap(Level.class);

    public static String formattedPrefix(String contextTag) {
        return String.format(PREFIX_DEFAULT_FMT, contextTag, StringUtils.getFirstNChars(agentId, 2));
    }

    public static void initComponentTag(String tag) {
        componentTag = tag;
    }

    public static String getComponentTag() {
        return componentTag;
    }

    public ConsoleLogger(String context) {
        this(context, Level.INFO);
    }

    public ConsoleLogger(Level level) {
        this(componentTag, level);
    }

    public ConsoleLogger(String context, Level level) {
        this(context, level, System.out, System.err);
    }

    public ConsoleLogger(String context, Level level, PrintStream stdOut, PrintStream stdErr) {
        this.context = context;
        this.prefix = ConsoleLogger.formattedPrefix(context);
        this.level = level;
        this.initLevelPrintStreamMap(stdOut, stdErr);
    }

    private void initLevelPrintStreamMap(PrintStream stdOut, PrintStream stdErr) {
        this.levelPrintStreamMap.put(Level.ALL, stdOut);
        this.levelPrintStreamMap.put(Level.TRACE, stdOut);
        this.levelPrintStreamMap.put(Level.DEBUG, stdOut);
        this.levelPrintStreamMap.put(Level.INFO, stdOut);
        this.levelPrintStreamMap.put(Level.WARN, stdOut);
        this.levelPrintStreamMap.put(Level.ERROR, stdErr);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Level getLevel() {
        return this.level;
    }

    private boolean isLogLevelEnabled(Level logLevel) {
        return Level.ERROR.equals((Object)logLevel) || logLevel.enabledAt(this.level);
    }

    private boolean isLogLevelEnabled(Marker marker, Level logLevel) {
        return SlMarkers.ALWAYS_PRINT == marker || this.isLogLevelEnabled(logLevel);
    }

    private void printLog(Level logLevel, String msg) {
        this.levelPrintStreamMap.get((Object)logLevel).println(msg);
    }

    private void log(Level logLevel, boolean checkLevel, String msg) {
        this.log(logLevel, checkLevel, true, msg);
    }

    private void log(Level logLevel, boolean checkLevel, boolean format, String msg) {
        if (!checkLevel || this.isLogLevelEnabled(logLevel)) {
            String msgToPrint = format ? this.format(logLevel, msg) : msg;
            this.printLog(logLevel, msgToPrint);
        }
    }

    private void log(Level logLevel, boolean checkLevel, String format, Object arg) {
        this.log(logLevel, checkLevel, false, this.format(logLevel, format, arg));
    }

    private void log(Level logLevel, boolean checkLevel, String format, Object arg1, Object arg2) {
        this.log(logLevel, checkLevel, false, this.format(logLevel, format, arg1, arg2));
    }

    private void log(Level logLevel, boolean checkLevel, String format, Object ... args) {
        this.log(logLevel, checkLevel, false, this.format(logLevel, format, args));
    }

    private void log(Level logLevel, boolean checkLevel, String msg, Throwable t) {
        this.log(logLevel, checkLevel, false, this.format(logLevel, this.messageWithThrowable(msg, t)));
    }

    private void log(Marker marker, Level logLevel, String msg) {
        this.log(logLevel, !SlMarkers.ALWAYS_PRINT.equals((Object)marker), msg);
    }

    private void log(Marker marker, Level logLevel, String format, Object arg) {
        this.log(logLevel, !SlMarkers.ALWAYS_PRINT.equals((Object)marker), format, arg);
    }

    private void log(Marker marker, Level logLevel, String msg, Throwable t) {
        this.log(logLevel, !SlMarkers.ALWAYS_PRINT.equals((Object)marker), msg, t);
    }

    private void log(Marker marker, Level logLevel, String format, Object arg1, Object arg2) {
        this.log(logLevel, !SlMarkers.ALWAYS_PRINT.equals((Object)marker), format, arg1, arg2);
    }

    private void log(Marker marker, Level logLevel, String format, Object ... args) {
        this.log(logLevel, !SlMarkers.ALWAYS_PRINT.equals((Object)marker), format, args);
    }

    @Deprecated
    public void println(String text) {
        this.status(text);
    }

    @Deprecated
    public void printError(String text) {
        this.error(text);
    }

    private String messageWithThrowable(String message, Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(", error: ");
        this.appendStackTrace(sb, t);
        return sb.toString();
    }

    private void appendStackTrace(StringBuilder sb, Throwable t) {
        SlStringBuilderWriter stringBuilderWriter = new SlStringBuilderWriter(sb);
        t.printStackTrace(new PrintWriter(stringBuilderWriter));
    }

    private StringBuilder createMessageStringBuilder(Level logLevel) {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.prefix).append(" - ").append(LEVEL_PREFIX_MAP.get((Object)logLevel));
    }

    private String format(Level logLevel, String msg) {
        return this.createMessageStringBuilder(logLevel).append(msg).toString();
    }

    private String format(Level logLevel, String format, Object arg) {
        return SlMsgFormatter.normalizedMessage(this.createMessageStringBuilder(logLevel), format, arg);
    }

    private String format(Level logLevel, String format, Object arg1, Object arg2) {
        return SlMsgFormatter.normalizedMessage(this.createMessageStringBuilder(logLevel), format, arg1, arg2);
    }

    private String format(Level logLevel, String format, Object ... args) {
        return SlMsgFormatter.normalizedMessage(this.createMessageStringBuilder(logLevel), format, args);
    }

    public String getName() {
        return this.context;
    }

    public boolean isTraceEnabled() {
        return Level.TRACE.enabledAt(this.level);
    }

    public void trace(String string) {
        this.log(Level.TRACE, true, string);
    }

    public void trace(String format, Object arg) {
        this.log(Level.TRACE, true, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, true, format, arg1, arg2);
    }

    public void trace(String format, Object ... args) {
        this.log(Level.TRACE, true, format, args);
    }

    public void trace(String text, Throwable t) {
        this.log(Level.TRACE, true, this.messageWithThrowable(text, t));
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isLogLevelEnabled(marker, Level.TRACE);
    }

    public void trace(Marker marker, String msg) {
        this.log(marker, Level.TRACE, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.log(marker, Level.TRACE, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.TRACE, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... args) {
        this.log(marker, Level.TRACE, format, args);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLogLevelEnabled(Level.DEBUG);
    }

    public void debug(String string) {
        this.log(Level.DEBUG, true, string);
    }

    public void debug(String format, Object arg) {
        this.log(Level.DEBUG, true, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, true, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, true, format, args);
    }

    public void debug(String text, Throwable t) {
        this.log(Level.DEBUG, true, this.messageWithThrowable(text, t));
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isLogLevelEnabled(marker, Level.DEBUG);
    }

    public void debug(Marker marker, String msg) {
        this.log(marker, Level.DEBUG, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.log(marker, Level.DEBUG, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.DEBUG, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... args) {
        this.log(marker, Level.DEBUG, format, args);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLogLevelEnabled(Level.INFO);
    }

    public void info(String string) {
        this.log(Level.INFO, true, string);
    }

    public void info(String format, Object arg) {
        this.log(Level.INFO, true, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, true, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, true, format, args);
    }

    public void info(String text, Throwable t) {
        this.log(Level.INFO, true, this.messageWithThrowable(text, t));
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isLogLevelEnabled(marker, Level.INFO);
    }

    public void info(Marker marker, String msg) {
        this.log(marker, Level.INFO, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.log(marker, Level.INFO, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.INFO, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... args) {
        this.log(marker, Level.INFO, format, args);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLogLevelEnabled(Level.WARN);
    }

    public void warn(String string) {
        this.log(Level.WARN, true, string);
    }

    public void warn(String format, Object arg) {
        this.log(Level.WARN, true, format, arg);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, true, format, args);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, true, format, arg1, arg2);
    }

    public void warn(String text, Throwable t) {
        this.log(Level.WARN, true, this.messageWithThrowable(text, t));
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isLogLevelEnabled(marker, Level.WARN);
    }

    public void warn(Marker marker, String msg) {
        this.log(marker, Level.WARN, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.log(marker, Level.WARN, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.WARN, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... args) {
        this.log(marker, Level.WARN, format, args);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLogLevelEnabled(Level.ERROR);
    }

    public void error(String string) {
        this.log(Level.ERROR, true, string);
    }

    public void error(String format, Object arg) {
        this.log(Level.ERROR, true, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, true, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, true, format, args);
    }

    public void error(String string, Throwable e) {
        this.log(Level.ERROR, true, this.messageWithThrowable(string, e));
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isLogLevelEnabled(marker, Level.ERROR);
    }

    public void error(Marker marker, String msg) {
        this.log(marker, Level.ERROR, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.log(marker, Level.ERROR, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.ERROR, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... args) {
        this.log(marker, Level.ERROR, format, args);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.ERROR, msg, t);
    }

    public void status(String message) {
        this.info(SlMarkers.ALWAYS_PRINT, message);
    }

    public void status(String format, Object arg) {
        this.info(SlMarkers.ALWAYS_PRINT, format, arg);
    }

    public void status(String format, Object arg1, Object arg2) {
        this.info(SlMarkers.ALWAYS_PRINT, format, arg1, arg2);
    }

    public void status(String format, Object ... args) {
        this.info(SlMarkers.ALWAYS_PRINT, format, args);
    }

    public void status(String msg, Throwable t) {
        this.info(SlMarkers.ALWAYS_PRINT, msg, t);
    }

    static {
        LEVEL_PREFIX_MAP.put(Level.ALL, "");
        LEVEL_PREFIX_MAP.put(Level.TRACE, "[TRACE] - ");
        LEVEL_PREFIX_MAP.put(Level.DEBUG, "[DEBUG] - ");
        LEVEL_PREFIX_MAP.put(Level.INFO, "");
        LEVEL_PREFIX_MAP.put(Level.WARN, "[WARN] - ");
        LEVEL_PREFIX_MAP.put(Level.ERROR, "[ERROR] - ");
    }
}

