/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.logging;

public enum Level {
    ALL("all", Integer.MIN_VALUE),
    TRACE("trace", 1000),
    DEBUG("debug", 10000),
    INFO("info", 20000),
    WARN("warn", 30000),
    ERROR("error", 40000),
    OFF("off", Integer.MAX_VALUE);

    private final String name;
    private final int priority;

    private Level(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean enabledAt(Level level) {
        return this.getPriority() >= level.getPriority();
    }

    public static Level get(String s) {
        for (Level level : Level.values()) {
            if (!level.name.equalsIgnoreCase(s)) continue;
            return level;
        }
        return null;
    }

    public boolean hasName(String s) {
        return this.name.equalsIgnoreCase(s);
    }
}

