/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.serviceproxy.buildsession;

import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.TextFileUtils;
import java.io.File;
import java.io.IOException;

public class BuildSessionIdFile {
    protected static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String DEFAULT_NAME = "buildSessionId.txt";
    public static final String DEFAULT_PATH = PathUtils.join(DefaultDirs.WORKING_DIR, "buildSessionId.txt");
    private final String path;

    public BuildSessionIdFile(String path) {
        this.path = path == null ? DEFAULT_PATH : path;
    }

    public void tryDeletePrevious() {
        File maybeOldBsidFile = new File(this.path);
        maybeOldBsidFile.delete();
    }

    public void tryCreate(String buildSessionId) {
        try {
            TextFileUtils.writeToFile(this.path, buildSessionId);
            CONSOLE_LOG.info("Build session id was received and saved in file '{}'", (Object)this.path);
        }
        catch (IOException e) {
            CONSOLE_LOG.error("Failed to create file with build session id='{}'. Error:", (Object)this.path, (Object)e);
        }
    }
}

