/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.serviceproxy.buildsession;

import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionCreateData;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionIdFile;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.PullRequestBuildSessionCreateData;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;

public class BuildSessionServiceProxyHandler
extends SLServiceProxy
implements BuildSessionServiceProxy {
    private static final String BUILDSESSION = "buildsession";
    private static final String PULL_REQUEST = "pull-request";
    private static final String BS_DATA_REJECTED_FMT = "Build-session data was rejected by server with code:%s, response:%s";
    private static final String FAILED_SEND_DATA = "Failed to send build session data to server";
    private static final String FAILED_GET_DATA = "Failed to get build session data from server";

    public BuildSessionServiceProxyHandler(SLAgentConfiguration cfg) {
        super(cfg);
    }

    public BuildSessionServiceProxyHandler(String token, String server, String proxyConfig) {
        super(token, server, proxyConfig);
    }

    @Override
    public String createBuildSessionId(BuildSessionData buildSessionData, String bsidFilePath) {
        SLHttpResult<String> slResult = this.sendCreateRequest(new BuildSessionCreateData(buildSessionData), bsidFilePath, false);
        return this.extractBuildSessionId(slResult);
    }

    @Override
    public BuildSessionData createBuildSession(BuildSessionData createData, String bsidFilePath) {
        SLHttpResult<String> slResult = this.sendCreateRequest(new BuildSessionCreateData(createData), bsidFilePath, false);
        return this.getCreatedSessionData(createData, slResult);
    }

    @Override
    public String createPullRequestBuildSessionId(PullRequestBuildSessionCreateData buildSessionCreateData, String bsidFilePath) {
        SLHttpResult<String> slResult = this.sendCreateRequest(new BuildSessionCreateData(buildSessionCreateData), bsidFilePath, true);
        return this.extractBuildSessionId(slResult);
    }

    @Override
    public BuildSessionData createPullRequestBuildSession(BuildSessionData buildSessionData, String bsidFilePath) {
        BuildSessionCreateData createData = new BuildSessionCreateData(buildSessionData);
        SLHttpResult<String> slResult = this.sendCreateRequest(createData, bsidFilePath, true);
        return this.requestCreatedSessionData(createData, slResult);
    }

    @Override
    public BuildSessionData getBuildSessionData(String buildSessionId) {
        BuildSessionData buildSessionData = null;
        try {
            String resolvedUrl = this.buildUrl("v2", "agents", BUILDSESSION, buildSessionId).toString();
            SLHttpResult<BuildSessionData> result = this.doGet(resolvedUrl);
            return result.getResponseObject();
        }
        catch (Exception e) {
            this.logError(FAILED_GET_DATA, e);
            return buildSessionData;
        }
    }

    protected SLHttpResult<String> sendCreateRequest(BuildSessionCreateData createData, String bsidFilePath, boolean forPullRequest) {
        BuildSessionIdFile buildSessionIdFile = new BuildSessionIdFile(bsidFilePath);
        buildSessionIdFile.tryDeletePrevious();
        String url = forPullRequest ? this.buildUrl("v2", "agents", BUILDSESSION, PULL_REQUEST) : this.buildUrl("v2", "agents", BUILDSESSION);
        try {
            SLHttpResult<String> slResult = this.doPost(url, createData);
            if (slResult.isStatusCodeOk()) {
                String buildSessionId = this.extractBuildSessionId(slResult);
                if (buildSessionId != null) {
                    buildSessionIdFile.tryCreate(buildSessionId);
                }
            } else if (slResult.getStatusCode() < 500) {
                this.logConsoleError(String.format(BS_DATA_REJECTED_FMT, slResult.getStatusCode(), slResult.getStatusMessage()));
            }
            return slResult;
        }
        catch (Exception e) {
            this.logError(FAILED_SEND_DATA, e);
            return null;
        }
    }

    private BuildSessionData requestCreatedSessionData(BuildSessionData createData, SLHttpResult<String> slResult) {
        if (slResult != null && slResult.isStatusCodeOk()) {
            return this.getBuildSessionData(slResult.getResponseObject());
        }
        return null;
    }

    private BuildSessionData getCreatedSessionData(BuildSessionData createData, SLHttpResult<String> slResult) {
        if (slResult != null && slResult.isStatusCodeOk()) {
            BuildSessionData resultData = null;
            if (slResult.getStatusCode() == 200) {
                resultData = this.getBuildSessionData(slResult.getResponseObject());
            }
            if (slResult.getStatusCode() == 201) {
                resultData = createData;
                resultData.setBuildSessionId(slResult.getResponseObject());
            }
            return resultData;
        }
        return null;
    }

    private String buildUrl(String ... pathParams) {
        return new UrlBuilder().withHost(this.getServer()).withPath(pathParams).build();
    }

    private SLHttpResult<String> doPost(String url, BuildSessionCreateData bsCreateData) {
        SLHttpResult<String> slResult = this.getHttpClient().sendRequestRetry(new SLHttpRequest<String>(this.getTag(), url, bsCreateData, String.class), new SLHttpClient.RequestRetry<String>(){

            @Override
            public SLHttpResult<String> execute(SLHttpRequest<String> slRequest) {
                return BuildSessionServiceProxyHandler.this.getHttpClient().sendPostRequest(slRequest);
            }

            @Override
            public boolean isRecoverableError(int httpCode) {
                if (400 == httpCode || 412 == httpCode) {
                    return false;
                }
                return super.isRecoverableError(httpCode);
            }
        });
        return slResult;
    }

    private SLHttpResult<BuildSessionData> doGet(String resolvedUrl) {
        return this.getHttpClient().sendGetRetry(new SLHttpRequest<BuildSessionData>(this.getTag(), resolvedUrl, BuildSessionData.class));
    }

    private String extractBuildSessionId(SLHttpResult<String> slResult) {
        if (slResult != null && slResult.isStatusCodeOk()) {
            return slResult.getResponseObject();
        }
        return null;
    }

    @Override
    public String getTag() {
        return "BSS";
    }
}

