/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.serviceproxy.version;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.version.VersionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.utils.threads.FastShutdownTimeoutTimer;
import io.sealights.onpremise.agents.infra.utils.threads.httptask.HttpRequestTask;
import io.sealights.onpremise.agents.infra.utils.threads.httptask.InputArgs;
import io.sealights.onpremise.agents.infra.utils.threads.httptask.ScheduledHttpRequestSender;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;

public class FileDownloadTask
extends HttpRequestTask<FileDownloadProcedure, FileDownloadInput> {
    private static Logger LOG = LogFactory.getLogger(FileDownloadTask.class);
    public static int DEFAULT_TIMEOUT_SECS = 300;
    private FileDownloadInput inputArgs;
    private DownloadTimeoutTimer timeoutTimer;
    private DownloadDoneCondition downloadDoneCondition = new DownloadDoneCondition();

    public FileDownloadTask(VersionServiceProxyHandler proxyHandler) {
        this.timeoutTimer = new DownloadTimeoutTimer(this.downloadDoneCondition);
        this.setRequestSender(new FileDownloadProcedure(proxyHandler, this.downloadDoneCondition));
    }

    protected FileDownloadTask(FileDownloadProcedure requestSender, DownloadDoneCondition downloadDoneCondition, DownloadTimeoutTimer timeoutTimer, int awaitMsecs) {
        super(awaitMsecs);
        this.downloadDoneCondition = downloadDoneCondition;
        this.timeoutTimer = timeoutTimer;
        this.setRequestSender(requestSender);
    }

    public boolean executeDownload() {
        LOG.info("start download to '{}', download timeout: {} MSec", (Object)this.getInputArgs().destFile, (Object)this.timeoutTimer.getExpirationMillis());
        this.downloadDoneCondition.executeWithLock(new Runnable(){

            @Override
            public void run() {
                try {
                    FileDownloadTask.this.start();
                    while (!FileDownloadTask.this.downloadDoneCondition.isDone()) {
                        FileDownloadTask.this.downloadDoneCondition.getInternalCondition().await();
                    }
                    FileDownloadTask.this.cancel();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    FileDownloadTask.this.cancel();
                }
            }
        });
        return this.downloadDoneCondition.isDownloadResultOk();
    }

    @Override
    public void start() {
        super.start();
        this.timeoutTimer.start();
    }

    @Override
    public void cancel() {
        this.timeoutTimer.cancel();
        super.cancel();
    }

    @Override
    public String getName() {
        return "download-agent";
    }

    @Override
    @Generated
    public FileDownloadInput getInputArgs() {
        return this.inputArgs;
    }

    @Generated
    public void setInputArgs(FileDownloadInput inputArgs) {
        this.inputArgs = inputArgs;
    }

    static class DownloadDoneCondition
    extends ReentrantLock {
        private final Condition internalCondition = this.newCondition();
        private boolean done = false;
        private boolean downloadResultOk = false;

        void executeWithLock(Runnable code) {
            this.lock();
            try {
                code.run();
            }
            finally {
                this.unlock();
            }
        }

        void trySetDone(final boolean downloadResult) {
            this.executeWithLock(new Runnable(){

                @Override
                public void run() {
                    if (!this.isDone()) {
                        LOG.debug("Condition done");
                        done = true;
                        downloadResultOk = downloadResult;
                        internalCondition.signalAll();
                    }
                }
            });
        }

        @Generated
        public DownloadDoneCondition() {
        }

        @Generated
        public Condition getInternalCondition() {
            return this.internalCondition;
        }

        @Generated
        public boolean isDone() {
            return this.done;
        }

        @Generated
        public boolean isDownloadResultOk() {
            return this.downloadResultOk;
        }

        @Generated
        public void setDone(boolean done) {
            this.done = done;
        }

        @Generated
        public void setDownloadResultOk(boolean downloadResultOk) {
            this.downloadResultOk = downloadResultOk;
        }

        @Override
        @Generated
        public String toString() {
            return "FileDownloadTask.DownloadDoneCondition(internalCondition=" + this.getInternalCondition() + ", done=" + this.isDone() + ", downloadResultOk=" + this.isDownloadResultOk() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadDoneCondition)) {
                return false;
            }
            DownloadDoneCondition other = (DownloadDoneCondition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isDone() != other.isDone()) {
                return false;
            }
            if (this.isDownloadResultOk() != other.isDownloadResultOk()) {
                return false;
            }
            Condition this$internalCondition = this.getInternalCondition();
            Condition other$internalCondition = other.getInternalCondition();
            return !(this$internalCondition == null ? other$internalCondition != null : !this$internalCondition.equals(other$internalCondition));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DownloadDoneCondition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isDone() ? 79 : 97);
            result = result * 59 + (this.isDownloadResultOk() ? 79 : 97);
            Condition $internalCondition = this.getInternalCondition();
            result = result * 59 + ($internalCondition == null ? 43 : $internalCondition.hashCode());
            return result;
        }
    }

    static class DownloadTimeoutTimer
    extends FastShutdownTimeoutTimer {
        private DownloadDoneCondition downloadDoneCondition;

        public DownloadTimeoutTimer(DownloadDoneCondition downloadDoneCondition) {
            super(DownloadTimeoutTimer.getTimeoutConfigValueSecs());
            this.downloadDoneCondition = downloadDoneCondition;
        }

        protected DownloadTimeoutTimer(DownloadDoneCondition downloadDoneCondition, int expirationMsec) {
            super(expirationMsec, TimeUnit.MILLISECONDS);
            this.downloadDoneCondition = downloadDoneCondition;
        }

        @Override
        public void run() {
            LOG.info("{} MSec timeout has expired, download will be cancelled", (Object)this.getExpirationMillis());
            this.downloadDoneCondition.trySetDone(false);
        }

        protected static int getTimeoutConfigValueSecs() {
            return SystemPropertiesHelper.getIntProperty("sl.fileDownloadTimeoutSec", DEFAULT_TIMEOUT_SECS);
        }

        @Override
        public String getName() {
            return "download-agent-timeout";
        }
    }

    static class FileDownloadProcedure
    implements ScheduledHttpRequestSender<FileDownloadInput> {
        private VersionServiceProxyHandler proxyHandler;
        private DownloadDoneCondition downloadDoneCondition;

        @Override
        public void sendRequest(FileDownloadInput input) {
            SLHttpResult.SLHttpResultVoid slResult = this.proxyHandler.getHttpClient().downloadFileRequest(this.proxyHandler.getTag(), input.getUrlToAgent(), input.getDestFile());
            if (slResult.isStatusCodeOk()) {
                LOG.info("file '{}' was downloaded successfully", (Object)input.getDestFile());
            } else {
                LOG.info("failure on download of file '{}', error:{}", (Object)input.getDestFile(), (Object)slResult.getStatusMessage());
            }
            this.downloadDoneCondition.trySetDone(slResult.isStatusCodeOk());
        }

        @Generated
        public VersionServiceProxyHandler getProxyHandler() {
            return this.proxyHandler;
        }

        @Generated
        public DownloadDoneCondition getDownloadDoneCondition() {
            return this.downloadDoneCondition;
        }

        @Generated
        public void setProxyHandler(VersionServiceProxyHandler proxyHandler) {
            this.proxyHandler = proxyHandler;
        }

        @Generated
        public void setDownloadDoneCondition(DownloadDoneCondition downloadDoneCondition) {
            this.downloadDoneCondition = downloadDoneCondition;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileDownloadProcedure)) {
                return false;
            }
            FileDownloadProcedure other = (FileDownloadProcedure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VersionServiceProxyHandler this$proxyHandler = this.getProxyHandler();
            VersionServiceProxyHandler other$proxyHandler = other.getProxyHandler();
            if (this$proxyHandler == null ? other$proxyHandler != null : !((Object)this$proxyHandler).equals(other$proxyHandler)) {
                return false;
            }
            DownloadDoneCondition this$downloadDoneCondition = this.getDownloadDoneCondition();
            DownloadDoneCondition other$downloadDoneCondition = other.getDownloadDoneCondition();
            return !(this$downloadDoneCondition == null ? other$downloadDoneCondition != null : !((Object)this$downloadDoneCondition).equals(other$downloadDoneCondition));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileDownloadProcedure;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VersionServiceProxyHandler $proxyHandler = this.getProxyHandler();
            result = result * 59 + ($proxyHandler == null ? 43 : ((Object)$proxyHandler).hashCode());
            DownloadDoneCondition $downloadDoneCondition = this.getDownloadDoneCondition();
            result = result * 59 + ($downloadDoneCondition == null ? 43 : ((Object)$downloadDoneCondition).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileDownloadTask.FileDownloadProcedure(proxyHandler=" + this.getProxyHandler() + ", downloadDoneCondition=" + this.getDownloadDoneCondition() + ")";
        }

        @Generated
        public FileDownloadProcedure(VersionServiceProxyHandler proxyHandler, DownloadDoneCondition downloadDoneCondition) {
            this.proxyHandler = proxyHandler;
            this.downloadDoneCondition = downloadDoneCondition;
        }
    }

    static class FileDownloadInput
    implements InputArgs {
        private String urlToAgent;
        private String destFile;

        @Generated
        public String getUrlToAgent() {
            return this.urlToAgent;
        }

        @Generated
        public String getDestFile() {
            return this.destFile;
        }

        @Generated
        public void setUrlToAgent(String urlToAgent) {
            this.urlToAgent = urlToAgent;
        }

        @Generated
        public void setDestFile(String destFile) {
            this.destFile = destFile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileDownloadInput)) {
                return false;
            }
            FileDownloadInput other = (FileDownloadInput)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$urlToAgent = this.getUrlToAgent();
            String other$urlToAgent = other.getUrlToAgent();
            if (this$urlToAgent == null ? other$urlToAgent != null : !this$urlToAgent.equals(other$urlToAgent)) {
                return false;
            }
            String this$destFile = this.getDestFile();
            String other$destFile = other.getDestFile();
            return !(this$destFile == null ? other$destFile != null : !this$destFile.equals(other$destFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileDownloadInput;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $urlToAgent = this.getUrlToAgent();
            result = result * 59 + ($urlToAgent == null ? 43 : $urlToAgent.hashCode());
            String $destFile = this.getDestFile();
            result = result * 59 + ($destFile == null ? 43 : $destFile.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileDownloadTask.FileDownloadInput(urlToAgent=" + this.getUrlToAgent() + ", destFile=" + this.getDestFile() + ")";
        }

        @Generated
        public FileDownloadInput(String urlToAgent, String destFile) {
            this.urlToAgent = urlToAgent;
            this.destFile = destFile;
        }
    }
}

